<?php 
/**
 * @package Pro.Radio Dedications
 * 
 * Admin Settings
 * 
 * */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/* ADMIN CSS and Js loading
=============================================*/
if(!function_exists('prdedications_scriptss')){
	add_action("admin_enqueue_scripts",'prdedications_scriptss');
	function prdedications_scriptss(){
		wp_enqueue_style( 'prdedications-styles', plugins_url( 'assets/css/admin-style.css' , __FILE__ ), false, PRDEDICATIONS__VERSION);
	}
}


/* ADMIN notification if there are dedications
=============================================*/
function prdedications_notification_link($wp_admin_bar) {
	if( function_exists('proradio_whmcs_check_service')){
		$service = proradio_whmcs_check_service( PRDEDICATIONS_SERVICE_NAME );
		if( $service ){
			$args = array(
				'post_type' => 'prdedicationslist',
				'post_status' => 'draft',
			);
			$wp_query_custom = new WP_Query( $args );
			$count = $wp_query_custom->found_posts; 
			if($count > 0){
				$args = array(
					'id' => 'prdedications',
					'title' => '<span class="ab-icon dashicons dashicons-heart"></span>' .esc_html__('THERE ARE NEW DEDICATIONS!'), 
					'href' =>  admin_url( 'edit.php?post_status=draft&post_type=prdedicationslist' ),
					'meta' => array(
						'class' => 'prdedications-notify',
						'title' => 'Review dedications'
						)
				);
				$wp_admin_bar->add_node($args);
			}	
		} else {
			
			$args = array(
				'id' => 'prdedications',
				'title' => '<span class="ab-icon dashicons dashicons-heart"></span>' .esc_html__('GET NOTIFIED!'), 
				'href' =>  admin_url( 'edit.php?post_type=prdedicationslist&page=prdedications_settings' ),
				'meta' => array(
					'class' => 'prdedications-promo',
					'title' => 'Promo dedications'
					)
			);
			$wp_admin_bar->add_node($args);
			
		}
	}
}
add_action('admin_bar_menu', 'prdedications_notification_link', 999);





/* Admin pages
=============================================*/
require_once '_form-generator.php';
require_once '_controls-filter.php';

// // Settings
require_once 'admin-pages/settings.php';

