/**
 * @package ProRadio Dedications 
 * @Version 1.1.0.2
 * @copyright 2022-2023 Qantum Themes SL - All rights reserved
 * */
(function($) {
	"use strict";






	$.fn.emoji = function (params) {
		var defaults = {
			button: '&#x1F642;',
			place: 'before',
			emojis: ['&#x1F642;', '&#x1F641;', '&#x1f600;', '&#x1f601;', '&#x1f602;', '&#x1f603;', '&#x1f604;', '&#x1f605;', '&#x1f606;', '&#x1f607;', '&#x1f608;', '&#x1f609;', '&#x1f60a;', '&#x1f60b;', '&#x1f60c;', '&#x1f60d;', '&#x1f60e;', '&#x1f60f;', '&#x1f610;', '&#x1f611;', '&#x1f612;', '&#x1f613;', '&#x1f614;', '&#x1f615;', '&#x1f616;', '&#x1f617;', '&#x1f618;', '&#x1f619;', '&#x1f61a;', '&#x1f61b;', '&#x1f61c;', '&#x1f61d;', '&#x1f61e;', '&#x1f61f;', '&#x1f620;', '&#x1f621;', '&#x1f622;', '&#x1f623;', '&#x1f624;', '&#x1f625;', '&#x1f626;', '&#x1f627;', '&#x1f628;', '&#x1f629;', '&#x1f62a;', '&#x1f62b;', '&#x1f62c;', '&#x1f62d;', '&#x1f62e;', '&#x1f62f;', '&#x1f630;', '&#x1f631;', '&#x1f632;', '&#x1f633;', '&#x1f634;', '&#x1f635;', '&#x1f636;', '&#x1f637;', '&#x1f638;', '&#x1f639;', '&#x1f63a;', '&#x1f63b;', '&#x1f63c;', '&#x1f63d;', '&#x1f63e;', '&#x1f63f;', '&#x1f640;', '&#x1f643;', '&#x1f4a9;', '&#x1f644;', '&#x2620;', '&#x1F44C;','&#x1F44D;', '&#x1F44E;', '&#x1F648;', '&#x1F649;', '&#x1F64A;'],
			fontSize: '27px',
			listCSS: {},
			rowSize: 8,
		};
		var settings = {};
		if (!params) {
			settings = defaults;
		} else {
			for (var n in defaults) {
				settings[n] = params[n] ? params[n] : defaults[n];
			}
		}

		this.each(function (n, input) {
			var $input = $(input);

			function showEmoji() {
				$list.show();
				$input.focus();
				setTimeout(function () {
					$(document).on('click', closeEmoji);
				}, 2000);
			}

			function closeEmoji() {
				$list.hide();
				$(document).off('click', closeEmoji);
			}

			function clickEmoji(ev) {

				
				var emoj = $(ev.currentTarget).find('img').attr('alt');
				// console.log(emoj);
				if('undefined' == emoj || 'undefined' == typeof(emoj)){
					 emoj = $(ev.currentTarget).html();
				}
				// console.log( emoj );
				if (input.selectionStart || input.selectionStart == '0') {
					var startPos = input.selectionStart;
					var endPos = input.selectionEnd;
					input.value = input.value.substring(0, startPos)
						+ emoj
						+ input.value.substring(endPos, input.value.length);
				} else {
					input.value += emoj;
				}
		
				closeEmoji();
				$input.focus();
				input.selectionStart = startPos + 2;
				input.selectionEnd = endPos + 2;
			}

			var $button = $('<span class="prdedications-emojibtn">').html(settings.button).css({cursor: 'pointer', 'font-size': settings.fontSize}).on('click', showEmoji);
			var $list = $('<div class="prdedications-emojilist">').css(defaults.listCSS).css(settings.listCSS);
			for (var n in settings.emojis) {
				if (n > 0 && n % settings.rowSize == 0) {
					$("<br>").appendTo($list);
				}
				$("<span>").html(settings.emojis[n]).attr('alt', settings.emojis[n] ).attr('data-emoji', settings.emojis[n] ).css({cursor: 'pointer', 'font-size': settings.fontSize}).on('click', clickEmoji).appendTo($list);
			}

			if (settings.place === 'before') {
				$button.insertBefore(this);
			} else {
				$button.insertAfter(this);
			}
			$list.insertAfter($input);
		});
		return this;
	};
	

	
	$.PRdedications = {
		errors: {
			name : 'The name is too short',
			missing : 'Error: the field is missing, incorrect or too short',
			link : 'Error: invalid URL format',
			phone : 'Error: incorrect phone number',
			email : 'The address is incorrect, please check again',
			dateFormat : 'Error: wrong date format',
			check : 'Please accept the privacy terms to proceed',
			formerror: 'Some fields are not correctly compiled, please check before proceeding.',
		},

		fn: {
			
			/**====================================================================
			 *
			 * 
			 *  Marquee for longer texts
			 *  
			 * 
			 ====================================================================*/
			marqueeInstances: [],
			marqueeText: function(that) {
				if('function' !== typeof( $.fn.marquee ) ){ // missing marquee library? quit
					return;
				}
				var marquees = $('body').find('.proradio-dedications-marquee');

				// Destroy any old instance of the marquee
				if( that.marqueeInstances.length > 0 ){
					for( var mi = 0; mi < that.marqueeInstances.length; mi++ ){
						if( 'undefined' !== typeof( that.marqueeInstances[mi] )){
							that.marqueeInstances[mi].marquee('destroy');
						}
					}
					that.marqueeInstances = []; // reset
				}
				$.each(marquees, function(i,c){
					var item = $(c);
					if(item.find('.marquee').length === 0){
						item.html('<span class="marquee">'+item.html()+'</span>');
					}
					var direction = 'left';
					if(item.hasClass('vertical')){
						 direction = 'up';
					}

					console.log( 'scroll');
					that.marqueeInstances[i] = item.marquee({
						gap: 10,
						delayBeforeStart: 0,
						pauseOnCycle: 0,
						startVisible: true
					});
				});
			},
			doValid: function(sel){
				$(sel).addClass('prdedications-valid');
			},
			doError: function(sel, e){
				$(sel).addClass('prdedications-invalid');
				console.log(e);
				// $(sel).after('<p class="prdedications-error-form">'+e+'</p>');
			},
			validateDate: function(testdate) {
			    var date_regex = /^\d{4}\-(0?[1-9]|1[012])\-(0?[1-9]|[12][0-9]|3[01])$/ ;
			    return date_regex.test(testdate);
			},
			isUrlValid: function(url) {
			    return /^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(url);
			},
			isPhoneValid: function(input) {
			    return /\(?([0-9]{3})\)?([ .-]?)([0-9]{3})\2([0-9]{4})/.test(input);
			},
			isEmailValid: function(input) {
			    // return /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/.test(input);
			    var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  				return regex.test(input);
			},
			validateForm: function(that, form){
				var errors = 0;

			 	$('.prdedications-error-message').removeClass('show');

				form.find('.prdedications-error-field').removeClass('prdedications-error-field');
				// form.find('.prdedications-invalid').removeClass('prdedications-invalid');

				 // Message check
			    var fieldMessage = form.find('textarea[name="your-message"]');
			   	if( fieldMessage.val().length < 10 ){
			    	$('.prdedications-error-message.your-message-error').addClass('show');
			    	errors ++;
			    } 

			    // Name check
			    var fieldName = form.find('input[name="your-name"]');
			    if( fieldName.length > 0 ){
				    if(fieldName.val() === '' || fieldName.val().length < 2 ){
				    	$('.prdedications-error-message.your-name-error').addClass('show');
				    	errors ++;
				    	return;
				    } 
				}

			     // Email check
			    var fieldEmail = form.find('input[name="your-email"]');
			    if( fieldEmail.length > 0 ){
				    if(!that.fn.isEmailValid( fieldEmail.val() )  ){
				    	$('.prdedications-error-message.your-email-error').addClass('show');
				    	errors ++;
				    } 
				}

			    var privacyField = form.find('[data-name="privacy"]');
			    if( privacyField.length > 0 ){
				    if(  ! privacyField.find('input[type="checkbox"]').is(":checked") ) {
				    	$('.prdedications-error-message.privacy-error').addClass('show');
				    	errors ++;
				    }
				}
			   
			    // checkbox check
			    if(0 === errors){
			    	return true;
			    } else {
			    	return false;
			    }
			},
			init: function( that ) {
				// $('.prdedications-fighter').hide();
				$('.prdedications-message').emoji();
				that.fn.songSuggestion.init( that );	
				that.fn.marqueeText( that.fn );
				var form = $('.prdedications-cform-form');
				form.on('click', '.prdedications-cform-submit',function(e){
					e.preventDefault();

					// ======================================= FORM =============================
					var isValid = that.fn.validateForm(that, form);
					var payload = form.serializeArray().reduce(function(a, x) { a[x.name] = x.value; return a; }, {});
					payload.action = 'prdedications-sendform';
					payload.nonce = prdedications_ajax_var.nonce;
					payload.url = prdedications_ajax_var.url;
					payload.pagelink = $(location).attr('href');
					payload.isValid = isValid;
					if(!isValid){
						return;
					}
					form.find('.prdedications-spinner').css({'display': "block"});
					$.ajax({
			            type: 'post',
			            url: prdedications_ajax_var.url,
			            data: payload,
			            cache: false,
			            success: function (data) {
			            	console.log(data);
			            	if(!isValid){
								e.preventDefault();
								form.find('.prdedications-spinner').css({'display': "none"});
								return false;
							}
			                form.find(':input')
							  .not(':button, :submit, :reset, :hidden')
							  .val('')
							  .prop('checked', false)
							  .prop('selected', false);

							if('limit' == data){
								form.find('.prdedications-response-limit').addClass('show');
								form.find('.prdedications-spinner').css({'display': "none"});
								return;
							}
							if('success' == data){
								form.find('.prdedications-response-success').addClass('show');
								form.find('.prdedications-response-error').removeClass('show');
								form.find('.prdedications-spinner').css({'display': "none"});
								
							} else {
								form.find('.prdedications-response-success').removeClass('show');
								form.find('.prdedications-response-error').addClass('show');
								form.find('.prdedications-spinner').css({'display': "none"});
							}
							return;
							
			            },
			            error: function (data) {
			                console.log('An error occurred.');
			                console.log(data);
			                form.find('.prdedications-spinner').css({'display': "none"});
			            },
			        });
				});
			},

			songSuggestion: {
				search: function(field){
					var searchTerm = field.val().split(' ').join('+');
					$.ajax("https://itunes.apple.com/search?", {
			            data: {
			                term: searchTerm,
			                country: 'US',
			                media: 'music',
			                limit: 10
			            },
			            dataType: "jsonp",
			            success: function(data) {
			                // console.log(data);
			                var result = $.map(data.results, function(item) {
			                    return {
			                        title: item.trackName,
			                        artist: item.artistName,
			                        thumb: item.artworkUrl100
			                    }
			                });
			                var html = '';
			                $.each(result, function(i,c){
			                	var i = $(c)[0];
			                	html += '<li><a href="#" data-prdedications-title="'+i.artist+' - '+i.title+'" data-prdedications-thumb="'+i.thumb+'"><img src="'+i.thumb+'"><p>'+i.title+'<br>'+i.artist+'</p></a></li>'
			                });
			                field.closest('form').find('.prdedications-suggestions').html( '<ul>'+html+'</ul>' );
			            }
			        });
				},
				init: function(that){
					var songSuggestion = this;
					$(".prdedications-songsearch").on('change input', function(){
						songSuggestion.search( $(this) );
					});
					$("body").on('click', '.prdedications-suggestions a', function(e){
						e.preventDefault();
						var song = $(this);
						var title = song.data('prdedications-title');
						var thumb = song.data('prdedications-thumb');
						$(".prdedications-songsearch").val(title);
						$(".prdedications-songsearch").closest('form').find('input[name="song-artwork"]').val(thumb);
						$(".prdedications-songsearch").closest('form').find('.prdedications-suggestions').html('');
					});
				}
			},

		}
	}

	jQuery(document).ready(function() {
		
		/**
		 * =======================================================
		 * submit
		 * =======================================================
		 * */
		$.PRdedications.fn.init( $.PRdedications );	
	});
	$(window).on('qtAjaxpageLoadEnd', function(){
		$.PRdedications.fn.init( $.PRdedications );	
	});
})(jQuery);