<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorDedicationsForm extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-dedications-form'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Dedications form', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-cf7';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}
	// public function __construct($data = [], $args = null) {
 //      parent::__construct($data, $args);
 //      wp_register_script( 'proradio-elementor-qt-caption', plugins_url( '/caption.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
 //   	}
 // 	public function get_script_depends() {
	//      return [ 'proradio-elementor-qt-caption' ];
	// }

	protected function register_controls() {
		$this->start_controls_section(
			'section_settings_form',
			[
				'label' => esc_html__( 'Settings', 'proradio-elementor' ),
			]
		);
			$this->add_responsive_control(
				'form-padding',
				[
					'label' => esc_html__( 'Padding', 'elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%', 'rem' ],
					'selectors' => [
						'{{WRAPPER}} .prdedications-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'form-radius',
				[
					'label' => esc_html__( 'Border-radius', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 30,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .prdedications-container' => 'border-radius: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'proradio-form-bg',
				[
					'label' => esc_html__( 'Background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .prdedications-container' => 'background-color: {{VALUE}};',
					],
				]
			);
			
		$this->end_controls_section();
	}

	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		prdedications_form_function();
	}
	
	protected function content_template() {}
}