<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorMenu extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-menu'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Menu', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-post-inline';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}
		/**
	 * @since version PR.2.3.0 loaded from minified scripts.
	 * To unse unminified, edit _plugin.php line 53 $use_minified_script = true;
	 * 
	 * 
	 * */
	// public function __construct($data = [], $args = null) {
 //      parent::__construct($data, $args);
 //      wp_register_script( 'proradio-elementor-qt-caption', plugins_url( '/caption.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
 //   	}
 // 	public function get_script_depends() {
	//      return [ 'proradio-elementor-qt-caption' ];
	// }
	protected function register_controls() {
		$this->start_controls_section(
			'section_icons',
			[
				'label' => esc_html__( 'Menu', 'proradio-elementor' ),
			]
		);
			
			$menus = wp_get_nav_menus();
			$menu_options = ['' => 'Choose a menu'];
			foreach ( $menus as $menu ){
				$menu_options[ $menu->term_id ] = esc_html( $menu->name );
			}
			$this->add_control(
				'pr_menu_id',
				[
					'label' => esc_html__( 'Choose menu', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'options' => $menu_options
				]
			);

			$this->add_control(
				'pr_menu_fx',
				[
					'label' => esc_html__( 'Animation', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'default' => 'proradio-menustyle-default',
					'options' =>[
						'proradio-menustyle-default'   => esc_attr__( 'Default', 'proradio' ),
						'proradio-menustyle-classic'   => esc_attr__( 'Classic', 'proradio' ),
						'proradio-menustyle-one'   => esc_attr__( 'Alternative', 'proradio' )
					]
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'pr-txt-typo',
					'label' => esc_html__( 'Typography','proradio-elementor'),
					'scheme' => Typography::TYPOGRAPHY_1,
					'selector' => '#proradio-global {{WRAPPER}} .proradio-menubar,  {{WRAPPER}} .proradio-menu-horizontal li a,  {{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li ul li a'
				]
			);

			$this->add_control(
				'text_align',
				[
					'label' => esc_html__( 'Alignment', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Left', 'textdomain' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'textdomain' ),
							'icon' => 'eicon-text-align-center',
						],
						'flex-end' => [
							'title' => esc_html__( 'Right', 'textdomain' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => 'center',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .proradio-menu-horizontal' => 'justify-content: {{VALUE}};',
					],
				]
			);

        
		$this->end_controls_section();


		/**
		 * Colors
		 */
		$this->start_controls_section(
			'menucolors',
			[
				'label' => esc_html__( 'Colors', 'elementor-proradio' ),
			]
		);
			$this->add_control(
				'pr-menu-bg',
				[
					'label' => esc_html__( 'Background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-menubar, {{WRAPPER}} .proradio-menu.proradio-paper, .proradio-headerbar__content.proradio-paper'=> 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'pr-menu-bgh',
				[
					'label' => esc_html__( 'Hover decoration', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li > a::after'=> 'border-color: {{VALUE}};',
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar.proradio-menustyle-one > li > a::after'=> 'border-color: {{VALUE}};',
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li:hover > a::before'=> 'border-color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'pr-menu-text',
				[
					'label' => esc_html__( 'Text', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li > a'=> 'color: {{VALUE}};',
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li.menu-item-has-children::after'=> 'color: {{VALUE}};'
					],
				]
			);

			$this->add_control(
				'pr-menu-text-h',
				[
					'label' => esc_html__( 'Text hover', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li:hover > a'=> 'color: {{VALUE}};',
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li.menu-item-has-children:hover::after, 
						{{WRAPPER}} .proradio-menubar > li:hover > a > span'=> 'color: {{VALUE}};',

						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar.proradio-menustyle-one > li:hover > a > span'=> 'color: {{VALUE}} !important;',

					],
				]
			);

		$this->end_controls_section();


		/**
		 * Colors
		 */
		$this->start_controls_section(
			'submenucolors',
			[
				'label' => esc_html__( 'Sub menu colors', 'elementor-proradio' ),
			]
		);

			$this->add_control(
				'pr-menu-bg-sub',
				[
					'label' => esc_html__( 'Background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li > ul li a'=> 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'pr-menu-bgh-sub',
				[
					'label' => esc_html__( 'Background hover', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar > li > ul li a'=> 'background-image: linear-gradient(45deg, {{VALUE}} 0%, {{VALUE}} 100%) !important;',
					],
				]
			);
			$this->add_control(
				'pr-menu-text-sub',
				[
					'label' => esc_html__( 'Text', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar li li a, {{WRAPPER}} .proradio-menubar li li.menu-item-has-children::after '=> 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'pr-menu-text-sub-h',
				[
					'label' => esc_html__( 'Text hover', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-menu-horizontal .proradio-menubar li li:hover a'=> 'color: {{VALUE}};',
					],
				]
			);
		$this->end_controls_section();



		
	}

	/**
	 * Frontend
	 */
	protected function render() {

		$atts = $this->get_settings_for_display();
		$pr_menu_id = $atts['pr_menu_id'];
		if( !$pr_menu_id || $pr_menu_id == 0 ){
			echo 'Please choose a menu. You can create a menu from Wp Dashboard > Appearance > Menu';
		} else {
			?>
			<nav class="proradio-menu-horizontal proradio-menu-horizontal--default">
				<div class="proradio-menu-horizontal_c">
					<ul class="proradio-menubar proradio-menubar-default <?php echo esc_attr( $atts['pr_menu_fx'] ); ?>">
					<?php
					wp_nav_menu( array(
						'menu' => $pr_menu_id,
						'depth' => 3,
						'container' => false,
						'items_wrap' => '%3$s'
					));
					?>
					</ul>
				</div>
			</nav>
			<?php  
		}
	}
	
	protected function content_template() {}
}