<?php  
/**
 * Create customizer fields for the kirki framework.
 * @package Kirki
 */


/**
 * MegaFooter plugin integration
 */
if( function_exists( 'proradio_megafooter_posttype_name' ) ){
	if(!function_exists('proradio_customizer_dropdown_mega_footer')){
		function proradio_customizer_dropdown_mega_footer(){
			$posts = Kirki_Helper::get_posts( array( 'posts_per_page' => -1,'post_type' => proradio_megafooter_posttype_name() ) );
			$posts[0] =  esc_html__('Chose', 'proradio');
			ksort($posts);
			return $posts;
		}
	}
	Kirki::add_field( 'proradio_megafooter_config', array(
		'type'        => 'repeater',
		'label'       => esc_attr__( 'Mega footer', 'proradio-megafooter'  ),
		'section'     => 'proradio_megafooter_options_section',
		'priority'    => 10,
		'row_label' => array(
			'type'  => 'field',
			'value' => esc_attr__('Mega footer', 'proradio-megafooter'  ),
			'field' => 'title',
		),
		'button_label' => esc_attr__('Add footer', 'proradio-megafooter'  ),
		'settings'     => 'proradio_megafooters',
		'fields' => array(
			'mega_footers' => array(
				'type'        => 'select',
				'choices' 	  =>  proradio_customizer_dropdown_mega_footer()
			)
		)
	));
}


/**
 * MegaFooter plugin integration
 */
if( function_exists( 'proradio_megafooter_posttype_name' ) ){

	Kirki::add_field( 'proradio_config', array(
	    'type'        => 'custom',
	    'settings'    => 'proradio_megaheader_options_section_0',
	    'label'       => '',
	    'section'     => 'proradio_megaheader_options_section',
	    'default'     =>  '<p>'.esc_html__( 'Manage your Mega Header with Elementor from Dashboard > Mega Footer. The default menu can be hidden in Logo & Menu Bars > Logo and menu bar design.', "proradio" ).'</p>',
	) );

	if(!function_exists('proradio_customizer_dropdown_mega_header')){
		function proradio_customizer_dropdown_mega_header(){
			$posts = Kirki_Helper::get_posts( array( 'posts_per_page' => -1,'post_type' => proradio_megafooter_posttype_name() ) );
			$posts[0] =  esc_html__('Chose', 'proradio');
			ksort($posts);
			return $posts;
		}
	}

	Kirki::add_field( 'proradio_megafooter_config', array(
		'type'        => 'repeater',
		'label'       => esc_attr__( 'Mega header', 'qtmplayer' ),
		'section'     => 'proradio_megaheader_options_section',
		'priority'    => 10,
		'row_label' => array(
			'type'  => 'field',
			'value' => esc_attr__('Mega header', 'proradio-megafooter'  ),
			'field' => 'title',
		),
		'button_label' => esc_attr__('Add header', 'proradio-megafooter'  ),
		'settings'     => 'proradio_megaheaders',
		'fields' => array(
			'mega_header' => array(
				'type'        => 'select',
				'choices' 	  =>  proradio_customizer_dropdown_mega_header()
			),

		)
	));

	Kirki::add_field( 'proradio_config', array(
		'settings'     => 'proradio_megaheaders_pos',
		'section'     => 'proradio_megaheader_options_section',
		'label'       => esc_html__( 'Position', "proradio" ),
		'transport'		=> 'auto',
		'type'        => 'select',
		'default'		=> 'relative',
		'choices'   => array(
			'relative'   => esc_attr__( 'Default', 'proradio' ),
			'fixed' 	=> esc_attr__( 'Fixed', 'proradio' ),
		),
		'output'    => array(
			array(
				'element'       => '#proradio-megafooter-header',
				'property' => 'position',
				'value_pattern' => esc_attr( ' $;' ),
			),
		)
	));





}
