<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * ======================================================
 *	Styling
 * ======================================================
 */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_styling',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Style', "proradio" ).'</h2>',
) );

/**
 * Buttons
 * ============================================================ */
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'buttons_radius',
	'label'       => esc_html__( 'Buttons corner radius', 'proradio' ),
	'description' => esc_html__( 'Affect border radius of every button from this theme', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'     => 3,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-arrow, .proradio-countdown__i, .proradio-slider__ab, .proradio-btn, .proradio-p-catz a, input[type="submit"],  .proradio-tags a, .ttg-btn-share,  .woocommerce a.button,#proradio-body.woocommerce #proradio-master .button,#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button,#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button,  a.button, .proradio-schedule .proradio-tabs__menu, .proradio-wp-pagination .page-numbers > span.proradio-btn',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.woocommerce #respond input#submit,.woocommerce a.button,.woocommerce button.button,.woocommerce input.button, #proradio-body.woocommerce .proradio-master .button, #proradio-body.woocommerce #proradio-master .woocommerce form .select2-container--default .select2-selection--single, .proradio-actions .proradio-a0::after, button.woocommerce-button::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px !important;' ),
		),
		// bbpress
		array(
			'element'       => 'button',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px !important;' ),
		),
		array(
			'element'       => '.qtmplayer__volume.proradio-btn.proradio-btn__r .qtmplayer__vcontainer, #proradio-body #proradio-master form input[type="submit"], #proradio-body #proradio-master form button, .proradio-comment__rlink a, .proradio-comment__cancelreply',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.proradio-tabs__menu li:first-child a',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px 0 0 $px' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-tabs__menu li:last-child a',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' 0 $px $px 0' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		
		array (
			'element' => '.qtmplayer-donutcontainer.proradio-a0, .qtmplayer-donutcontainer.proradio-a0::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( '50%' ),
		),

		array(
			'element'       => 'button:not(.owl-dot):not(.proradio-btn__txt):not(.owl-dot):not(.owl-prev):not(.owl-next):not([aria-controls]):hover::after,
			button:not(.owl-dot):not(.proradio-btn__txt):not(.owl-dot):not(.owl-prev):not(.owl-next):not([aria-controls])::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px !important;' ),
			'media_query' => '@media (min-width: 1200px)'
		),



		
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'btn_fontsize_m',
	'label'       => esc_html__( 'Font size mobile', 'proradio' ),
	'description' => esc_html__( 'Default font size for buttons', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'transport'   => 'auto',
	'default'		=> 12,
	'choices'     => [
		'min'  => 10,
		'max'  => 16,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-btn',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
			'media_query' => '@media (max-width: 760px)'
		),
	)
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'btn_fontsize',
	'label'       => esc_html__( 'Font size desktop', 'proradio' ),
	'description' => esc_html__( 'Default font size for buttons', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'transport'   => 'auto',
	'default'		=> 15,
	'choices'     => [
		'min'  => 8,
		'max'  => 22,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-btn',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
			'media_query' => '@media (min-width: 760px)',
		),
	)
] );

/**
 * ======================================================
 *	Button colors
 * ======================================================
 */


Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_colors',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Buttons background', "proradio" ).'</h2>',
) );

$selectors_list = array(
	'button:not(.owl-dot):not(.owl-prev):not(.owl-next):not(.proradio-btn__txt):not([aria-controls])',
	'input[type="submit"]', 
	'.proradio-entrycontent .wp-block-button .wp-block-button__link', 
	'.proradio-entrycontent .wp-block-button .wp-block-file__button', 
	'.proradio-btn.proradio-active',
	'.proradio-btn-primary', 
	'.woocommerce #respond input#submit',
	'.woocommerce a.button', 
	'.woocommerce button.button', 
	'.woocommerce input.button',
	'.woocommerce a.button',
	'#proradio-body.woocommerce #proradio-master .button',
	'#proradio-body.woocommerce .proradio-master #respond input#submit', 
	'#proradio-body.woocommerce .proradio-master .woocommerce #respond input#submit', 
	'#proradio-body.woocommerce .proradio-master .woocommerce a.button', 
	'#proradio-body.woocommerce .proradio-master .woocommerce button.button', 
	'#proradio-body.woocommerce .proradio-master .woocommerce input.button', 
	'#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button',
	'#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button',  
	'a.button'
);




Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_background',
	'label'       => esc_html__( 'Buttons background', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => '#ff0062',
	'transport'   => 'auto',
	// 'priority'    => 2,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		// array(
		// 	'element'       => implode(',',$selectors_list),
		// 	'property'      => 'background-color',
		// 	 'suffix'   => ' !important',
		// ),
		array(
			'element'       => ':root,html',
			'property'      => '--proradio-btn-bg-one',
		),
		array(
			'element'       => ':root,html',
			'property'      => '--prum-btn-background-color--accent-mid',
		),
	),
));



/**
 * ========================================
 * Optional: bg2
 * ========================================
 * */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_color_mid',
	'label'       => esc_html__( 'Gradient', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => 'rgba(255, 0, 98, 0)',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => ':root,html',
			'property'      => '--proradio-btn-bg-two',
		),
		array(
			'element'       => ':root,html',
			'property'      => '--prum-btn-background-color--accent-mid',
		),
		array(
			'element'       => '.proradio-menubtns__c',
			'property'      => '--proradio-btn-bg-two',
		),
	),
));




Kirki::add_field( 'proradio_config', array(
	'type'      => 'slider',
	'settings'  => 'proradio_btn_color_direction',
	'label'     => esc_attr__( 'Direction', 'proradio' ),
	'section'   => 'proradio_buttons_section',
	'default'   => 45,
	// 'priority'  => 12,
	'transport'   => 'auto',
	'choices'   => array(
		'min'  => 0,
		'max'  => 360,
		'step' => 1,
	),
    'output'    => array(
		array(
			'element'       => ':root,html',
			'property'      => '--proradio-btn-grad-dir',
			'value_pattern'   => '$deg',
		),
	)
) );







/**
 * ========================================
 * Optional: text color
 * ========================================
 * */

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_col',
	'label'       => esc_html__( 'Buttons color', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => '#ffffff',
	'transport'   => 'auto',
	// 'priority'    => 0,
	'choices'     => [
		'alpha' => false,
	],
	'output'    => array(
		array(
			'element'       => implode(',',$selectors_list),
			'property'      => 'color',
			 'suffix'   => ' !important',
		),
	),
));






/**
 * ========================================================================================================================
 * Buttons Hover
 * ========================================================================================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_colors_h',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Buttons hover', "proradio" ).'</h2>',
) );


// Hover classes array
$hover_selectors = array();
foreach( $selectors_list as $selector){
	$hover_selectors[] = $selector.':hover';
}
// Hover background
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_background_h',
	'label'       => esc_html__( 'Buttons hover', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => '#be024a',
	'transport'   => 'auto',
	// 'priority'    => 0,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => ':root,html',
			'property'      => '-proradio-btn-bg-one-h',
		),
		// array(
		// 	'element'       =>'.proradio-btn.proradio-btn-primary:hover::after, .proradio-btn.proradio-btn-primary:hover, .proradio-btn-primary::after ',
		// 	'property'      => 'background-color',
		// 	'media_query' => '@media (min-width: 100px)',
		// 	 'suffix'   => ' !important',
		// ),
		array(
			'element'       => implode(',',$hover_selectors),
			'property'      => 'background-color',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
		),

	),
));



