<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 * Logo and menu bar
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header0',
    'label'       => '',
    'section'     => 'proradio_header_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Menu visibility', "proradio" ).'</h2><p>'.esc_html__( 'Toggle default main menu based on screen size. Works well with MegaHeader to replace the default menu with a custom one.', "proradio" ).'</p>',
) );


Kirki::add_field( 'proradio_config', array(
	
	'settings'    => 'hide_main_menu',
	'label'       => esc_html__( 'Desktop', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'		=> 'auto',
	'type'        => 'select',
	'default'		=> 'table',
	'choices'   => array(
		'table'   => esc_attr__( 'Show', 'proradio' ),
		'none' 	=> esc_attr__( 'Hide', 'proradio' ),
	),
	'output'    => array(
		array(
			'element'       => '#proradio-menu',
			'property' => 'display',
			'media_query' => '@media (min-width: 1200px)'
		),
	)
));
Kirki::add_field( 'proradio_config', array(
	
	'settings'    => 'hide_main_menu_med',
	'label'       => esc_html__( 'Tablet', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'		=> 'auto',
	'type'        => 'select',
	'default'		=> 'block',
	'choices'   => array(
		'block'   => esc_attr__( 'Show', 'proradio' ),
		'none' 	=> esc_attr__( 'Hide', 'proradio' ),
	),
	'output'    => array(
		array(
			'element'       => '#proradio-menu',
			'property' => 'display',
			'media_query' => '@media (min-width: 670px) and (max-width: 1119px)'
		),
	)
));
Kirki::add_field( 'proradio_config', array(
	
	'settings'    => 'hide_main_menu_mobile',
	'label'       => esc_html__( 'Mobile', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'		=> 'auto',
	'type'        => 'select',
	'default'		=> 'block',
	'choices'   => array(
		'block'   => esc_attr__( 'Show', 'proradio' ),
		'none' 	=> esc_attr__( 'Hide', 'proradio' ),
	),
	'output'    => array(
		array(
			'element'       => '#proradio-menu',
			'property' => 'display',
			'media_query' => '@media (max-width: 670px)'
		),
	)
));




/**
 * ======================================================
 *	Menu bar type
 * ======================================================
 */


Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header1',
    'label'       => '',
    'section'     => 'proradio_header_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Menu type', "proradio" ).'</h2>',
) );


// Transparent

Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'proradio_header_transp',
	'label'       => esc_html__( 'Transparent menu', "proradio" ),
	'section'     => 'proradio_header_section',
	'description' => esc_html__( 'Default color will be white with transparency enabled', "proradio" ),
	// 'priority'    => 0,
	'default'     => '0',
));






// sticky header
Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'proradio_header_sticky',
	'label'       => esc_html__( 'Sticky menu', "proradio" ),
	'section'     => 'proradio_header_section',
	'description' => esc_html__( 'On scroll, stick the menu', "proradio" ),
	// 'priority'    => 1,
	'default'     => '0'
));







Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'menu_height',
	'label'       => esc_html__( 'Logo and menu height', 'proradio' ),
	'section'     => 'proradio_header_section',
	'default'     => 100,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 30,
		'max'  => 200,
		'step' => 2,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-unscrolled .proradio-menu__cont',
			'property'      => 'min-height',
			'value_pattern' => esc_attr( ' $px; ' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-unscrolled .proradio-menu__logo, .proradio-unscrolled .proradio-logolink',
			'property'      => 'height',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-unscrolled .proradio-menu__logo, .proradio-unscrolled .proradio-logolink, .proradio-logo_header.proradio-sitename',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-unscrolled .proradio-menu__logo img',
			'property'      => 'max-height',
			'value_pattern' => esc_attr( ' $px; ' ),
			'media_query' => '@media (min-width: 1200px)'
		),	


	),
] );





Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'menu_height_scrolled',
	'label'       => esc_html__( 'Logo and menu height scrolled', 'proradio' ),
	'section'     => 'proradio_header_section',
	'default'     => 60,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 30,
		'max'  => 160,
		'step' => 1,
	],
	'active_callback' => [
		[
			'setting'  => 'proradio_header_sticky',
			'operator' => '==',
			'value'    => true
		]
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menu__cont',
			'property'      => 'min-height',
			'value_pattern' => esc_attr( ' $px; ' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-menu__logo, .proradio-logolink',
			'property'      => 'height',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-menu__logo, .proradio-logolink, .proradio-logo_header.proradio-sitename',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-menu__logo img',
			'property'      => 'max-height',
			'value_pattern' => esc_attr( ' $px; ' ),
			'media_query' => '@media (min-width: 1200px)'
		),		
	),
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'logo_margin',
	'label'       => esc_html__( 'Logo margin', 'proradio' ),
	'section'     => 'proradio_header_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menu__logo',
			'property'      => 'margin-left',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'menu_padding',
	'label'       => esc_html__( 'Menu vertical padding', 'proradio' ),
	'section'     => 'proradio_header_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 40,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menu__cont',
			'property'      => 'padding-top',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),	
		array(
			'element'       => '.proradio-menu__cont',
			'property'      => 'padding-bottom',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),	
	),
] );


// Template
Kirki::add_field( 'proradio_config', array(
	'type'      => 'select',
	'settings'  => 'menu_template',
	'label'     => esc_html__( 'Menu template', 'proradio' ),
	'section'   => 'proradio_header_section',
	'multiple'    => false,
	'default'	=> 'default',
	'choices'   => array(
		'default'   => esc_attr__( 'Default', 'proradio' ),
		'double' 	=> esc_attr__( '2 Bars menu', 'proradio' ), // double is part of the css class, do not change
	),
));


// Template
Kirki::add_field( 'proradio_config', array(
	'type'      => 'select',
	'settings'  => 'menu_direction',
	'label'     => esc_html__( 'Menu direction', 'proradio' ).' '.esc_html__( 'Desktop', 'proradio' ),
	'section'   => 'proradio_header_section',
	'multiple'    => false,
	'default'	=> 'default',
	'choices'   => array(
		'row'   => esc_attr__( 'Default', 'proradio' ),
		'row-reverse' 	=> esc_attr__( 'Row reverse', 'proradio' ),
		'column' 	=> esc_attr__( 'Column', 'proradio' ),
		'column-reverse' 	=> esc_attr__( 'Column reverse', 'proradio' ),
		
	),
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu__cont',
			'property'      => 'flex-direction',
			'media_query' => '@media (min-width: 1200px)'
		),
	),
));

// Template
Kirki::add_field( 'proradio_config', array(
	'type'      => 'select',
	'settings'  => 'menu_order',
	'label'     => esc_html__( 'Menu order', 'proradio' ).' '.esc_html__( 'Desktop', 'proradio' ),
	'section'   => 'proradio_header_section',
	'multiple'    => false,
	// 'default'	=> 'default',
	'choices'   => array(
		'default'   => esc_attr__( 'Default', 'proradio' ),
		'-1' 	=> esc_attr__( 'First', 'proradio' ),
		'5' 	=> esc_attr__( 'Last', 'proradio' ),
	),
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu-horizontal',
			'property'      => 'order',
			'media_query' => '@media (min-width: 1200px)'
		),
	),
	'active_callback' => [
		[
			'setting'  => 'menu_template',
			'operator' => '!==',
			'value'    => 'double',
		]
	],
));



Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'menu_inner_padding',
	'label'       => esc_html__( 'Inner menu padding', 'proradio' ),
	'section'     => 'proradio_header_section',
	'default'     => [
		'padding-top'    => '0px',
		'padding-bottom' => '0px',
		'padding-left'   => '0px',
		'padding-right'  => '0px',
	],
	'transport'   => 'auto',
	'output'    => array(
		array(
			 'choice'      => 'padding-top',
			'element'       => '.proradio-menu-horizontal',
			'property'      => 'padding-top',
			'media_query' => '@media (min-width: 1200px)'
		),	
		array(
			 'choice'      => 'padding-bottom',
			'element'       => '.proradio-menu-horizontal',
			'property'      => 'padding-bottom',
			'media_query' => '@media (min-width: 1200px)'
		),

		array(
			 'choice'      => 'padding-left',
			'element'       => '.proradio-menu-horizontal',
			'property'      => 'padding-left',
			'media_query' => '@media (min-width: 1200px)'
		),

		array(
			 'choice'      => 'padding-right',
			'element'       => '.proradio-menu-horizontal',
			'property'      => 'padding-right',
			'media_query' => '@media (min-width: 1200px)'
		),	
	),
] );



// Template
Kirki::add_field( 'proradio_config', array(
	'type'      => 'select',
	'settings'  => 'menu_alignment',
	'label'     => esc_html__( 'Menu alignment', 'proradio' ),
	'section'   => 'proradio_header_section',
	'multiple'    => false,
	'default'	=> 'default',
	'choices'   => array(
		''   => esc_attr__( 'Default', 'proradio' ),
		'flex-start' 	=> esc_attr__( 'Left', 'proradio' ), // double is part of the css class, do not change
		'flex-end' 	=> esc_attr__( 'Right', 'proradio' ), // double is part of the css class, do not change
		'center' 	=> esc_attr__( 'Center', 'proradio' ), // double is part of the css class, do not change
	),
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '#proradio-menunav',
			'property'      => 'justify-content',
			'media_query' => '@media (min-width: 1200px)'
		),
	),
));




/**
 * ======================================================
 *	Logo
 * ======================================================
 */



Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header2',
    'label'       => '',
    'section'     => 'proradio_header_section',
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Logo', "proradio" ).'</h2>',
    // 'priority'    => 0,
) );



Kirki::add_field( 'proradio_config', array(
	'type'        => 'image',
	'settings'    => 'proradio_logo_header',
	'label'       => esc_html__( 'Logo header opaque', "proradio" ),
	'section'     => 'proradio_header_section',
	'description' => esc_html__( 'Max height: 100px', "proradio" ),
	// 'priority'    => 0
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'image',
	'settings'    => 'proradio_logo_header_transparent',
	'label'       => esc_html__( 'Logo header transparent', "proradio" ),
	'section'     => 'proradio_header_section',
	'description' => esc_html__( 'Max height: 100px', "proradio" ),
	// 'priority'    => 0
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'image',
	'settings'    => 'proradio_logo_header_mob',
	'label'       => esc_html__( 'Logo header mobile', "proradio" ),
	'description' => esc_html__( 'Max height: 50px', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10
));





/**
 * ======================================================
 *	Colors
 * ======================================================
 */



Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header3',
    'label'       => '',
    'section'     => 'proradio_header_section',
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Colors', "proradio" ).'</h2>',
    // 'priority'    => 10,
) );







// Menu colors
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_bg',
	'label'       => esc_html__( 'Main background', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'		=> 'refresh',
	// 'priority'    => 10,
	'transport'   => 'auto',
	// 'active_callback' => [
	// 	[
	// 		'setting'  => 'proradio_header_transp',
	// 		'operator' => '==',
	// 		'value'    => '0',
	// 	]
	// ],
	'output'    => array(
		array(
			'element'       => '.proradio-menu.proradio-paper, .proradio-headerbar__content.proradio-paper, .proradio-menu-horizontal .proradio-menubar > li > ul li a',
			'property'      => 'background-color',
		),
	),
));





// Transparent menu colors

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_scroll_bg',
	'label'       => esc_html__( 'Main background scrolled', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  => 'proradio_header_transp',
			'operator' => '==',
			'value'    => true,
		]
	],
	'output'    => array(
		array(
			'element'       => '.proradio-scrolled #proradio-menu.proradio-menu.proradio-paper',
			'property'      => 'background-color',
		),
	),

));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_scroll_t',
	'label'       => esc_html__( 'Text when scrolled', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  => 'proradio_header_transp',
			'operator' => '==',
			'value'    => true,
		]
	],
	'output'    => array(
		array(
			'element'       => '.proradio-scrolled #proradio-menu.proradio-menu.proradio-paper',
			'property'      => 'color',
		),
	),
));




// TEMPLATE 2 SECOND BAR NON TRANSPARENT BACKGROUND
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'bottombar_bg',
	'label'       => esc_html__( 'Second bar background', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  => 'menu_template',
			'operator' => '==',
			'value'    => 'double',
		],
	],
	'output' => array(
		array(
			'element'       => '.proradio-menu-horizontal--double',
			'property'      => 'background-color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'bottombar_bg_s',
	'label'       => esc_html__( 'Second bar background scrolled', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  => 'menu_template',
			'operator' => '==',
			'value'    => 'double',
		],
		[
			'setting'  => 'proradio_header_transp',
			'operator' => '==',
			'value'    => true,
		],
	],
	'output' => array(
		array(
			'element'       => '.proradio-scrolled .proradio-menu-horizontal--double',
			'property'      => 'background-color',
		),
	),
));



Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'bottombar_links',
	'label'       => esc_html__( 'Second bar links', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  => 'menu_template',
			'operator' => '==',
			'value'    => 'double',
		]
	],
	'output' => array(
		array(
			'element'       => '.proradio-menu-horizontal--double .proradio-menubar',
			'property'      => 'color',
		),
	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'bottombar_links_s',
	'label'       => esc_html__( 'Second bar links scrolled', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  => 'menu_template',
			'operator' => '==',
			'value'    => 'double',
		],
		[
			'setting'  => 'proradio_header_transp',
			'operator' => '==',
			'value'    => true,
		],
	],
	'output' => array(
		array(
			'element'       => '.proradio-scrolled .proradio-menu-horizontal--double .proradio-menubar',
			'property'      => 'color',
		),
	),
));



Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_t',
	'label'       => esc_html__( 'Opaque menu links color', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu, .proradio-menu-horizontal .proradio-menubar > li > ul li, .proradio-menubtns .proradio-btn',
			'property'      => 'color',
		),
	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_t_tras',
	'label'       => esc_html__( 'Transparent menu links color', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu-transp.proradio-unscrolled .proradio-menu.proradio-paper, .proradio-headerbar__content.proradio-paper ',
			'property'      => 'color',
		),
	),
));




// Submenu
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_l',
	'label'       => esc_html__( 'Sub menu links color', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu a, .proradio-menu-horizontal .proradio-menubar > li > ul li a',
			'property'      => 'color',
		),
	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_lh',
	'label'       => esc_html__( 'Main menu links hover color', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu a:hover, .proradio-menu-horizontal .proradio-menubar > li > ul li a:hover,  .proradio-menubar > li:hover > a > span',
			'property'      => 'color',
		),
		array(
			'element'       => '.proradio-menu-horizontal .proradio-menubar > li > a::after',
			'property'      => 'border-color',
		),

	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_lhs',
	'label'       => esc_html__( 'Main menu optional decoration color', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'   => 'auto',
	'default'	=> 'rgba(255,0,0,0)',
	'choices'     => [
			'alpha' => true,
		],
	'output'    => array(
		array(
			'element'       => '.proradio-menu-horizontal .proradio-menubar.proradio-menustyle-one>li>a::after',
			'property'      => 'border-color',
			'media_query' => '@media (min-width: 1200px)'
		),

	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'submenu_bg_col',
	'label'       => esc_html__( 'Sub menu background', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu-horizontal .proradio-menu-horizontal_c .proradio-menubar > li ul li, .proradio-menu-horizontal .proradio-menubar > li > ul li a',
			'property'      => 'background-color',
		),

	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'submenu_bg_h',
	'label'       => esc_html__( 'Sub menu background', "proradio" ).' - '.esc_html__( 'hover', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'   => 'auto',
	'default'		=> '',
	'output'    => array(
		array(
			'element'       => '.proradio-menu-horizontal .proradio-menubar > li > ul li a',
			'property'      => 'background-image',
			'value_pattern' =>'linear-gradient(45deg, $ 0%, $ 100%) !important;',
		),

	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'submenu_bg_h_t',
	'label'       => esc_html__( 'Sub menu links color', "proradio" ).' - '.esc_html__( 'hover', "proradio" ),
	'section'     => 'proradio_header_section',
	// 'priority'    => 10,
	'transport'   => 'auto',
	'default'		=> '',
	'output'    => array(
		array(
			'element'       => '.proradio-menu-horizontal .proradio-menubar > li ul li:hover > a',
			'property'      => 'color',
		),

	),
));




/**
 * ======================================================
 *	Colors mobile
 * ======================================================
 */



Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header3m',
    'label'       => '',
    'section'     => 'proradio_header_section',
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Colors mobile', "proradio" ).'</h2>',
) );


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_bg_m',
	'label'       => esc_html__( 'Main background mobile', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menu.proradio-paper, .proradio-headerbar__content.proradio-paper, .proradio-menu-horizontal .proradio-menubar > li > ul li a',
			'property'      => 'background-color',
			'media_query' => '@media (max-width: 1200px)'
		),
	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_menu_scroll_t_m',
	'label'       => esc_html__( 'Text color mobile', "proradio" ),
	'section'     => 'proradio_header_section',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '#proradio-menu.proradio-menu.proradio-paper, .proradio-menu, .proradio-menu-horizontal .proradio-menubar > li, .proradio-menubtns .proradio-btn, .proradio-logolink',
			'property'      => 'color',
			'media_query' => '@media (max-width: 1200px)'
		)
	),
));


/**
 * ======================================================
 *	Extra contents
 * ======================================================
 */


Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header_cont',
    'label'       => '',
    'section'     => 'proradio_header_section',
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Contents', "proradio" ).'</h2>',
) );


// aggiungere campo editor adsslot_menubar

Kirki::add_field( 'proradio_config', array(
  'type'     => 'editor',
  'settings' => 'proradio_ad_menubar',
  'multiple'    => false,
  'label'    => esc_html__( 'Content, ads or shortcode in menu', 'proradio' ),
  'section'  => 'proradio_header_section',
  'description' => __( 'Display custom content or shortcodes', 'mytheme' ),

));