<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}



/**
 * =====================================================
 * Global layout
 * =====================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'layout_capt_1',
    'label'       => '',
    'section'     => 'proradio_layout_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Global container', "proradio" ).'</h2>',
) );




/**
 * Layout
 * ============================================================ */
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'layout_width',
	'label'       => esc_html__( 'Maximum width', 'proradio' ),
	'description' => esc_html__( 'maximum width of the external container', "proradio" ),
	'section'     => 'proradio_layout_section',
	'default'     => 3000,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 1260,
		'max'  => 6000,
		'step' => 10,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-master, .proradio-headerbar__content, .proradio-global, .qtmplayer__playlistcontainer',
			'property'      => 'max-width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-menu__cont, .qtmplayer__controls, .proradio-secondaryhead__cont, .proradio-breadcrumb__list',
			'property'      => 'max-width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),

		
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_header_transp_margin',
	'label'       => esc_html__( 'Content offset', 'proradio' ),
	'description' => esc_html__( 'Adjust to match the vertical offset of the contents', "proradio" ),
	'section'     => 'proradio_layout_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => -360,
		'max'  => 360,
		'step' => 2,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menu-transp.proradio-menu-scroll .proradio-master, .proradio-menu-transp .proradio-master, .proradio-menu-stick .proradio-master',
			'property'      => 'margin-top',
			'value_pattern' => esc_attr( ' $px' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),
] );




Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'layout_container_shadow',
	'label'       => esc_html__( 'Container shadow', 'proradio' ),
	'section'     => 'proradio_layout_section',
	'default'     => 0.5,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.05,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-global',
			'property'      => 'box-shadow',
			'value_pattern' => esc_attr( ' 0px 0px 20px 0px rgba(0,0,0,$); ' ),
		),
	),
] );


/**
 * Load more
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_loadmore',
	'label'       => esc_html__( 'Load more', "proradio" ),
	'section'     => 'proradio_layout_section',
	'description' => esc_html__( 'Replace pagination with a load more button', "proradio" ),
));







