<?php 
 

/**
 * Load more
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'filmgrain',
	'label'       => esc_html__( 'Film grain', "proradio" ),
	'section'     => 'proradio_fx_section',
	'description' => esc_html__( 'Add a film grain to the screen', "proradio" ),
	'priority'    => 10,
	'transport'   => 'auto',
	'default'	=> 'none',

	'multiple'    => false,
	'choices'   => array(
		'none'   => esc_attr__( 'Disable', 'proradio' ),
		'block' 	=> esc_attr__( 'Enable', 'proradio' ), // double is part of the css class, do not change
	),
	'output'    => array(
		array(
			'element'       => '.proradio-fx-container',
			'property'      => 'display',
		),
	)
));


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'filmgrain_opa',
	'label'       => esc_html__( 'Film grain opacity', 'proradio' ),
	'section'     => 'proradio_fx_section',
	'default'     => 0.5,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.05,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-fx-container',
			'property'      => 'opacity',
		),
	),
	'active_callback' => [
		[
			'setting'  => 'filmgrain',
			'operator' => '==',
			'value'    => 'block',
		]
	],
] );


/**
 * Load more
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'proradio_fx',
	'label'       => esc_html__( 'Images hover effect', "proradio" ),
	'section'     => 'proradio_fx_section',
	'description' => esc_html__( 'Choose the effect for the elements hover', "proradio" ),
	'priority'    => 10,
	'default'	=> '',

	'multiple'    => false,
	'choices'   => array(
		''   => esc_attr__( 'Disable', 'proradio' ),
		'glitch' 	=> esc_attr__( 'VHS Glitch', 'proradio' ), // double is part of the css class, do not change
	)
));

	
if ( ! function_exists( 'proradio_fx_body_class' ) ) {
	add_filter('body_class', 'proradio_fx_body_class');
	// echo get_theme_mod( 'proradio_fx');die();
	
	function proradio_fx_body_class($classes){

		if( get_theme_mod( 'proradio_fx')  ){
			$classes[] =  esc_attr( 'proradio-fx-'.get_theme_mod( 'proradio_fx') );
		}
		return $classes;
	}
}


