<?php
/**
 * @package WordPress
 * @subpackage proradio-post
 * @version 1.0.1
 */

if(!function_exists('proradio_post_scroller_function')){
	function proradio_post_scroller_function($atts = []){

		ob_start();

		/*
		 *  Defaults
		 *  All parameters can be bypassed by same attribute in the shortcode
		 */
		extract( shortcode_atts( array(
			'post_type' 			=>  $post_type,
			'posts_per_page' 		=> (int)$items_per_page,
			'post_status' 			=> 'publish',
			'paged' 				=> $paged,
			'suppress_filters' 		=> false,
			'offset' 				=> (int)$offset,
			'ignore_sticky_posts' 	=> 1,
			'orderby' 				=> trim( esc_attr($orderby) ),
			'order' 				=> trim( esc_attr($order) ),
			'meta_key'				=> $meta_key,
			'post__not_in'			=> explode(',', trim($exclude) ),
			'items_per_page'=> 3,
			'pr_thumb' => '1',
			'duration' => 60
		), $atts ) );

		$duration = intval($duration) * 10000;

		$paged = 1;

		include 'helpers/query-prep.php';

		$wp_query = new WP_Query( $args );

	   ?>
	   <div class="proradio-post-scroller">
			<div class="proradio-text-marquee" data-duplicated='true' data-direction='left' data-duration='<?php echo esc_attr($duration); ?>'>
				<?php 
				if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
					$post = $wp_query->post;
					setup_postdata( $post );
					?>
					<a href="<?php the_permalink(); ?>" class="proradio-postitem-inline-text">
						<span>
							<?php  
							if($pr_thumb && has_post_thumbnail() ){
								the_post_thumbnail('thumbnail');
							}
							?>
							<span class="proradio-postitem-text">
								<?php echo esc_html( get_the_title() ); ?>
							</span>
						</span>
					</a>
					<?php  
				endwhile; else:
					esc_html_e("Currently there are no new post","proradio"); 
				endif;
				wp_reset_postdata();
				?>
			</div>
		</div>
		<?php  
		echo ob_get_clean();
	}   
}