<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.0
 * Theme function for custom parts:
 * display the full radio schedule
*/
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

if(!function_exists('proradio_showgrid')) {
	function proradio_showgrid($atts){
		
		extract( shortcode_atts( array(
			'schedulefilter' => '',
      'schedule_template' => false,
      'schedule_switch' => false,
      'schedule_style'=> '',
      'thumbsize' => 'medium'
		), $atts ) );


    $args = array(
      'schedulefilter' => $schedulefilter,
      'schedule_template' =>  $schedule_template,
      'schedule_switch' => $schedule_switch,
      'schedule_style' => $schedule_style,
      'thumbsize' => $thumbsize
    );

		ob_start();
    if( !isset( $schedulefilter ) ){
      $schedulefilter = false;
    } else {
      $schedulefilter = str_replace('schedulefilter:', '', $schedulefilter);
    }
		get_template_part('template-parts/schedule/schedule', null,   $args  );
    remove_query_arg( 'schedulefilter' );
		return ob_get_clean();
	}
}

if(function_exists('proradio_core_custom_shortcode')) {
	proradio_core_custom_shortcode("qt-schedule","proradio_showgrid");
}

/**
 *  Visual Composer integration
 */
add_action( 'vc_before_init', 'proradio_vc_showgrid' );
if(!function_exists('proradio_vc_showgrid')){
function proradio_vc_showgrid() {
  vc_map( array(
     "name" => esc_html__( "Shows schedule", "proradio" ),
     "base" => "qt-schedule",
     "icon" => get_template_directory_uri(). '/img/qt-logo.png',
     "description" => esc_html__( "Display a hero section of the show actually playing", "proradio" ),
     "category" => esc_html__( "Theme shortcodes", "proradio"),
     "params" => array(
      	array(
           "type" => "textfield",
           "heading" => esc_html__( "Filter by 'schedulefilter' taxonomy", "proradio" ),
           "description" => esc_html__("Insert the slug of a schedulefilter taxonomy for multi-radio websites","proradio"),
           "param_name" => "schedulefilter"
        )
     )
  ) );
}}