<?php  

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


if ( ! function_exists( 'proradio_welcome_page_elementor_settings' ) ) {
	function proradio_welcome_page_elementor_settings() {
		?>
		<div class="proradio-welcome proradio-welcome__page">
			<div class="proradio-welcome__container" id="proradio-elementor-settings">
				<div class="proradio-welcome__defaultcontainer" style="padding-right:30px;">
					<h3><?php esc_html_e('Protection from conflicting Elementor features', 'proradio'); ?></h3>
					<p><?php esc_html_e('This theme hides by default incompatible features, such as the Elementor Theme Builder.', 'proradio'); ?></p>
					<p style="color: red;font-weight:bold;"><?php esc_html_e("Replacing theme parts with custom templates created with the Elementor Theme Builder will break the functionalities of your website.", 'proradio'); ?></p>
					<p><?php esc_html_e("Is the equivalent of replacing the components of your computer: no support can be provided in case of issues, because it won't be our theme anymore.", 'proradio'); ?><br>
					<form method="post" action="<?php echo admin_url() . 'admin.php?page=proradio-elementor-settings&proradio-elementor-settings=1'; ?>" style="padding: 30px; border: 1px solid #9e9e9e">
						<?php 
						wp_nonce_field( 'proradio_elementor_protection_switch_action', 'proradio_elementor_protection_switch_field' );

						if( get_option( 'proradio_elementor_protection', '1' ) ){
							?>
							
							<input type="hidden" name="proradio-elementor-status" id="proradio-elementor-status" value="0">
							<p><input type="submit" name="submit" value="<?php esc_html_e('Disable Elementor features protection - this allows you to break your website', 'proradio'); ?>"  class="proradio-btn button button-error"></p>
							<h4>Elementor features protection is <span style="color:green">enabled</span>. Conflicting features are hidden, you don't risk to break the site.</h4>
							<?php  
						} else {
							?>
							<img src="<?php echo esc_url( get_theme_file_uri('/inc/tgm-plugin-activation/img/theme-builder.png' )); ?>" alt="<?php esc_attr_e('theme builder','proradio'); ?>" style="max-width:100%;height:auto;">
							<input type="hidden" name="proradio-elementor-status" id="proradio-elementor-status" value="1">
							<p><input type="submit" name="submit" value="<?php esc_html_e('Enable Elementor protection', 'proradio'); ?>"  class="proradio-btn button button-primary"></p>
							<h4>Elementor features protection is <span style="color:red">disabled</span>. Conflicting features are available, you can override the theme parts and this can cause functionality issues.</h4>
							<?php  
						}
						?>
					</form>
				</div>
			</div>
		</div>
		<?php
	}
}


/**
* ======================================
* Elementor protection switch
* ======================================
*/
if ( ! function_exists( 'proradio_elementor_settings_switcher' ) ) {
	if( isset( $_GET ) && isset( $_POST ) ){
		if( isset( $_GET[ 'proradio-elementor-settings' ] ) && isset( $_POST[ 'proradio-elementor-status' ] ) ){
			add_action( 'admin_init', 'proradio_elementor_settings_switcher' );
		}
	}
	function proradio_elementor_settings_switcher() {
		if ( wp_verify_nonce( $_POST[ 'proradio_elementor_protection_switch_field' ], 'proradio_elementor_protection_switch_action') ) {
			if( $_POST[ 'proradio-elementor-status' ] == '0') {
				$val = '0';
			} else {
				$val = '1';
			}
			update_option( 'proradio_elementor_protection', $val );
		} else {
			echo 'Nonce fail';
		}
	}
}

/**
* ======================================
* Frontend output
* ======================================
*/
if ( ! function_exists( 'proradio_elementor_settings_frontend' ) ) {
	add_action( 'wp_footer', 'proradio_elementor_settings_frontend' );
	function proradio_elementor_settings_frontend() {

		if( get_option( 'proradio_elementor_protection', '1' ) ){
			?>
			<!-- ProRadio Features Protection is on -->
			<?php
		} else {
			?>
			<!-- ProRadio Features Protection is off -->
			<?php
		}
	}
}


