<div id="basic-usage" class="getting-started-content content-basic-usage">
    <div class="content-heading">
        <h2><?php esc_html_e('Using Dracula Dark Mode Plugin', 'dracula-dark-mode'); ?></h2>
        <p><?php esc_html_e('Learn how to easily enable and use dark mode with the Dracula Dark Mode plugin', 'dracula-dark-mode'); ?></p>
    </div>

    <section class="section-faq">
        <!-- Frontend Dark Mode -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('1. Enable Dark Mode on Site Frontend', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Frontend dark mode refers to the implementation of a dark color scheme on a website frontend while
                    users interact. This feature is highly applicable for users when they spend a lot of time on your website’s front
                    end.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('To enable dark mode on the website frontend follow the below steps:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong> %s', 'From your admin dashboard, navigate to ', 'Dracula > Settings > General Settings', 'and turn on the Enable Frontend Dark Mode setting. The setting is enabled by default.' ); ?>
                    </li>
                    <li><?php esc_html_e('Once frontend dark mode is enabled, you will notice more 2 options below:', 'dracula-dark-mode') ?></li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Default Dark Mode:', 'Turn on the Default Dark Mode setting to set the dark mode theme on your website by default. This means that when a visitor first arrives on the website, they
                        will see the dark mode version of the site instead of the regular light mode.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Auto Match OS Theme:', 'Enable the Auto Match OS Theme setting to automatically detects the user\'s device OS theme and automatically enable the website\'s dark mode to match the
                        dark mode setting on the user\'s device.'); ?>
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/4DEidfYhb08?rel=0"
                            title="YouTube video player" frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>

            </div>
        </div>

        <!-- Admin Dashboard Dark Mode -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('2. Enable Dark Mode on Admin Dashboard', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Dracula Dark Mode allows site admins to enable and use dark mode in their admin dashboard.
                    This provides a consistent look and feel throughout the site, and can also help to reduce eye strain
                    when working in the admin dashboard.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('To enable the admin dashboard dark mode follow the below steps:', 'dracula-dark-mode'); ?></h4>

                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong> %s', 'From your admin dashboard, navigate to ', 'Dracula > Settings > Dashboard Dark Mode', 'and turn on the Enable Dashboard Dark Mode setting.'); ?>
                    </li>
                    <li>
                        <?php esc_html_e('After enabling the dashboard dark mode, you will notice 3 more options below:', 'dracula-dark-mode'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Classic Editor Dark Mode:', 'Enable this setting to enable the dark mode color scheme for the Classic Editor to make the editing experience more comfortable.'); ?>
                    </li>
                    <li>
                        <strong></strong> 
                        <?php echo sprintf('<strong>%s</strong> %s', 'Block Editor Dark Mode:', 'You can also enable the dark mode color scheme for the Gutenberg Block editor. After enabling the Block Editor Dark Mode a new dark mode toggle button
                        will be added to the editor.'); ?>
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/qOuFxLoinuE?rel=0" frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>

        <!-- Toggle Builder -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('3. Create Custom Dark Mode Toggle Button', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('You don\'t have to stick with the toggle buttons we designed for you. Dracula Dark Mode allows to
                    create custom dark mode toggle switch buttons. that provides a button builder that gives the ability to
                    create and customize the appearance and behavior of the toggle switch button. You can select button layout,
                    choose an icon or upload yours, set the button height, width, text & icon color, background color,
                    border width and color, border radius, and many more options.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('Follow the below steps to create a customized toggle button for Dark Mode:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php esc_html_e('First of all, give a name for the toggle button name in the Toggle Title input field.', 'dracula-dark-mode'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Layout:', 'From the Layout tab, choose your preferred button layout from our pre-made button layout designs.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Content:', 'From the content tab you can customize the button content such as button text, and button icons, and also set custom class names for the button. You can choose your
                        favorite icon for the button from 26+ provided attractive icons as well as also can upload any custom SVG
                        image as the icon.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Style:', 'From the Style tab, you can customize & set your preferred button styles & colors as per your need. You can set custom width, padding, text and icon size, text & icon
                        color, background color, border width, border color, border radius, text & icon spacing, and many more options.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong> %s', 'After you finished, click the', 'Save Changes', 'button.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('%s <code>%s</code>%s', 'Now you can display your custom toggle button anywhere using the shortcode', '[dracula_toggle id=”BUTTON_ID”]', 'for the users to enable/ disable the dark mode on the site.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong> %s', 'Also, all the custom-created toggle buttons will be displayed on the', 'Settings Page > Toggle Switch', 'tab. You can display them as the floating switch or in the menu by just
                        selecting them from the settings.'); ?>
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/J5rRiJfw22w?rel=0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>

        <!-- Include/ Exclude Post Pages -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('4. Include/ Exclude any Posts, Pages or Custom Post Types in Dark Mode', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('It might be sometimes necessary to exclude or include specific posts, pages, or any custom post
                    types in dark mode. Dracula Dark Mode allows to easily include or exclude certain pages, posts, any custom post types
                    in dark mode.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('Follow the below steps to include/ exclude any posts, pages or custom post types:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong>%s', 'From your admin dashboard, navigate to', 'Dracula > Settings > Excludes Settings', '.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Exclude Posts/Pages:', 'Select the posts, pages, or any custom post types from the drop-down menu to exclude from dark mode. You can select multiple pages or posts by searching them from the drop-down list. You can also select the Login & Register Page, 404 Page, Search Page,
                        and the Archive Page from the drop-down list.'); ?>
                        <strong> </strong> 
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Include Posts/ Pages:', 'If you want to exclude all of your posts, pages, and custom post types and include specific posts, and pages in dark mode, Enable the Exclude all switch and select the specific posts, pages or custom post types from the except dropdown list to include in dark mode.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Exclude Specific Sections/ Elements:', 'Dracula Dark Mode also lets you exclude any unwanted sections or elements on a page to be excluded from the dark mode. You can exclude any specific sections or elements by adding their CSS selectors in the input field.'); ?>
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/O17lW1aKYXs?rel=0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>

        <!-- Exclude Elements -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('5. Exclude Specific Sections/ Elements in a Page from Dark Mode', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Dracula Dark Mode also lets you exclude any unwanted sections or elements on a page to be excluded
                    from the dark mode. You can exclude any specific sections or elements in a page by using their CSS selectors.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('Follow the below steps to exclude specific elements in page from dark mode:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong>.', 'From your admin dashboard, navigate to', 'Dracula > Settings > Excludes Settings'); ?>
                    </li>
                    <li>
                        <?php esc_html_e('From the Exclude Settings field, you have to click on the Add Element button and insert the CSS selector for the element in the input field every time to exclude a new element.', 'dracula-dark-mode'); ?>
                    </li>
                    <li>
                        <p>
                            <?php esc_html_e('You can use the developer tools built into your web browser to find the CSS selector of an
                            element.', 'dracula-dark-mode'); ?>
                        </p>

                        <p>
                            <?php esc_html_e('Right-click on the element you want to select and choose "Inspect" from the context menu.', 'dracula-dark-mode'); ?>
                        </p>
                        <p>
                            <?php esc_html_e('The browser\'s developer tools will open and the element will be highlighted in the HTML code.', 'dracula-dark-mode'); ?>
                        </p>
                        <p>
                            <?php esc_html_e('Look for the element in the HTML and find the CSS class or ID attribute associated with it.', 'dracula-dark-mode'); ?>
                        </p>
                        <p>
                            <?php esc_html_e('Copy the ID or CLASS and use it to exclude the input field preceded by a "." for CLASS or "#" for ID.', 'dracula-dark-mode'); ?>
                        </p>
                    </li>
                    <li>
                        <p>
                            <?php esc_html_e('You can also easily exclude specific selectors or elements in live edit mode with just one click.', 'dracula-dark-mode'); ?>
                        </p>

                        <p>
                            <?php esc_html_e('To exclude specific elements in live edit mode, Click the Live Edit Button. Click the
                            Excludes Elements menu and then click the Select Element button.', 'dracula-dark-mode'); ?>
                        </p>

                        <p>
                            <?php esc_html_e('Now you can visually select any element on the page by clicking.', 'dracula-dark-mode'); ?>
                        </p>

                        <p>
                            <?php esc_html_e('The elements will be highlighted while you hover over an element and click on the element
                            that you want to exclude and the CSS selector for the element will be automatically inserted in
                            the Exclude Elements input field.', 'dracula-dark-mode'); ?>
                        </p>
                    </li>
                    <li>
                        <?php esc_html_e('Save changes when you are done.', 'dracula-dark-mode'); ?>
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/MzcCTjg4CN8?rel=0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>

        <!-- Image and Video Replacement -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('6. Replace Light Mode Images and Videos In Dark Mode', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Sometimes all the images & videos don\’t look better in dark mode, and you might want to replace them
                    in dark mode. Dracula Dark Mode lets you replace the light-mode images and videos with different images
                    and videos in dark mode.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('Follow the below steps to replace any light mode image in dark mode:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong>.', 'From your admin dashboard, navigate to', 'Dracula > Settings > Image Settings > Image Replacement'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Add a New Group:', 'You have to add a new group for each image that you want to replace. After adding a new group you will find two input fields for entering the image URL.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Light Mode Image:', 'Enter the URL of the light mode image that you want to replace in dark mode.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Dark Mode Image:', 'Enter the URL of the dark mode image that you want to replace the light mode image.'); ?>
                    </li>
                </ol>

                <h4><?php esc_html_e('Follow the below steps to replace any light mode videos in dark mode:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong>.', 'From your admin dashboard, navigate to', 'Dracula > Settings > Video Settings > Video Replacement'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Add a New Group:', 'You have to add a new group for each video that you want to replace. After adding a new group you will find two input fields for entering the video URL. You can replace any Self-Hosted video, YouTube video, Vimeo video, and Dailymotion video.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Light Mode Video:', 'Enter the URL of the light mode video that you want to replace in dark mode.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Dark Mode Video:', 'Enter the URL of the dark mode video that you want to replace the light mode video.'); ?>
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/GhDguYi0w_s?rel=0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>

        <!-- Realtime Dark Mode Customizations -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('7. Customize Dark Mode Preferences in Realtime Preview', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Realtime dark mode customization is the most important & unique feature that allows website admins to edit & customize dark mode settings in a real-time preview. For example, color adjustments, toggle switch customization, typography, exclude elements, and custom CSS can be customized.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('Follow the below steps to customize dark mode settings in realtime preview:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php esc_html_e('From your admin dashboard navigate to Dracula > Settings page and click the Live Edit button. After clicking the button you will be redirected to the site homepage and can find a widget on the top-right side.', 'dracula-dark-mode'); ?>
                    </li>
                    <li>
                        <?php esc_html_e('You can also show the live edit widget on any page while you are logged in by clicking the Live Edit button from the admin bar on the top of the page while you are browsing the site.', 'dracula-dark-mode'); ?>
                    </li>
                </ol>

                <h4><?php esc_html_e('You can customize the below dark mode settings in the Live Edit Widget:', 'dracula-dark-mode'); ?></h4>
                <ul>
                    <li><?php esc_html_e('Colors', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Color Adjustments', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Toggle Switch', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Typography', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Exclude Elements', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Custom CSS', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Image Settings', 'dracula-dark-mode'); ?></li>
                    <li><?php esc_html_e('Video Settings', 'dracula-dark-mode'); ?></li>

                </ul>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/cUizkL-VX3k?rel=0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>

        <!-- Page Specific Dark Mode -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('8. Set Page-Specific Dark Mode Settings', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Dracula Dark Mode allows you to set and customize every page of your website separately with different dark mode color schemes, switch variations, typography styles, and many others settings.', 'dracula-dark-mode'); ?>
                </p>
                <p>
                    <?php esc_html_e('This gives you the flexibility and fully customize controls to present every page of your website more perfectly in dark mode and create a unique experience for the visitors.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('You can customize the page-specific dark mode settings in 4 ways:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Live Edit Widget:', 'Set dark mode settings for specific pages/posts using the Live Edit Widget. Choose \'Current Page\' mode for page-specific changes or \'Template\' mode to
                        adjust settings across similar post types.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Classic Editor:', 'Adjust dark mode preferences for individual pages/posts via the Dark Mode Settings meta box within the Classic Editor.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Gutenberg Block Editor:', 'Adjust dark mode preferences for individual pages/posts via the Dark Mode Settings meta box in the Gutenberg Block Editor.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Elementor Page Builder:', 'Customize dark mode settings for specific pages/posts using the Dark Mode Settings panel under Elementor Page Builder settings.'); ?>
                        <strong></strong> 
                    </li>
                </ol>


                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/sEwLfy_54Sk?rel=0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen></iframe>
                </div>
            </div>
        </div>
        
        <!-- Reading Mode -->
        <div class="faq-item">
            <div class="faq-header">
                <i class="dashicons dashicons-arrow-down-alt2"></i>
                <h3><?php esc_html_e('9. How to Enable Reading Mode?', 'dracula-dark-mode'); ?></h3>
            </div>

            <div class="faq-body">
                <p>
                    <?php esc_html_e('Reading Mode enhances user experience by providing a distraction-free environment, removing clutter from articles and posts for improved focus.', 'dracula-dark-mode'); ?>
                </p>
                <p>
                    <?php esc_html_e('It prioritizes readability, accessibility, and ease of navigation, making it an invaluable tool for engaging and effortless content interaction.', 'dracula-dark-mode'); ?>
                </p>

                <h4><?php esc_html_e('To enable Reading Mode, follow the below steps:', 'dracula-dark-mode'); ?></h4>
                <ol>
                    <li>
                        <?php echo sprintf('%s <strong>%s</strong> %s', 'Form your WordPress Admin dashboard navigate to', 'Dark Mode > Settings > Reading Mode > Enable Reading Mode',' from the General tab.'); ?>
                    </li>
                    <li>
                        <?php esc_html_e('After enabling Reading Mode, you will discover more options.', 'dracula-dark-mode'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Display Post Types:', 'This settings represents which types you want to display the Reading Mode button. Ex: Posts, Pages, Landing Pages, and others.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Display On:', 'This settings represents page types where the Reading Mode button will be displayed. Ex: Single Page, Blog Page, Archive Page, and Search Page.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Reading Mode Button:', 'The reading mode button can be customized and displayed inside your page or post content. Ex: button style, button icon, button color, and others.'); ?>
                    </li>
                    <li>
                        <?php echo sprintf('<strong>%s</strong> %s', 'Reading Mode Layout:', 'Reading Mode layout is also customizable. Such as customizing the components (tools), appearance, and progress bar settings.'); ?>
                        <strong></strong> 
                    </li>
                </ol>

                <div class="col-image">
                    <iframe src="https://www.youtube.com/embed/-eL20lz83Ec?rel=0"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                        allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

</div>

<script>
    jQuery(document).ready(function ($) {
        $('#basic-usage .faq-item .faq-header').on('click', function () {
            $(this).parent().toggleClass('active');
        });
    });
</script>