<?php
/**
 * Plugin Name: Pro.Radio Core
 * Plugin URI: http://pro.radio
 * Author: Pro.Radio
 * Author URI: http://pro.radio
 * Description: Adds custom type and custom fields capabilities
 * Text Domain: proradio-core
 * Domain Path: /languages
 * Version: PR.6.1.0
*/


/**
 *
 *	For theme to check if is active
 * 
 */
if(!function_exists('proradio_core_active')){
	function proradio_core_active() {
		return true;
	}
}



/**
* Returns current plugin version.
* @return string Plugin version. Needs to stay here because of plugin file path
*/
if(!function_exists('proradio_core_active_get_version')){
function proradio_core_active_get_version() {
    if ( is_admin() ) {
        $plugin_data = get_plugin_data( __FILE__ );
        $plugin_version = $plugin_data['Version'];
    } else {
        $plugin_data = get_file_data(__FILE__, [ 'Version' => 'Version' ], 'plugin');
        $plugin_version = $plugin_data['Version'];
    }
    return $plugin_version;
}}

/**
 *
 *	The plugin textdomain
 * 
 */
if(!function_exists('proradio_core_load_plugin_textdomain')){
    add_action( 'plugins_loaded', 'proradio_core_load_plugin_textdomain' );
    function proradio_core_load_plugin_textdomain() {
    	load_plugin_textdomain( 'proradio-core', FALSE, basename( dirname( __FILE__ ) ) . '/languages' );
    }
}



/**
 *
 *	Metaboxes component
 * 
 */
if(!function_exists('custom_meta_box_field')){
	require	plugin_dir_path( __FILE__ ) . '/inc/backend/metaboxes/meta_box.php';
}


/**
 *  Kirki Framework Files Inclusion
 */
if(!function_exists( 'proradio_core_deactivate_plugin_conditional' ) ){
    add_action( 'admin_init', 'proradio_core_deactivate_plugin_conditional' );
    function proradio_core_deactivate_plugin_conditional() {
        $kirki_path = 'kirki/kirki.php';
        if ( is_plugin_active( $kirki_path ) ) {
            deactivate_plugins($kirki_path, true);    
        }
    }
}

if ( ! function_exists( 'Kirki' ) ) {
    require plugin_dir_path( __FILE__ ) . '/inc/backend/kirki/kirki.php';
}
if ( ! class_exists( 'Kirki2_Kirki' ) ) {
    require plugin_dir_path( __FILE__ ) . '/inc/backend/kirki-config-class/class-kirki2-kirki.php';
    require plugin_dir_path( __FILE__ ) . '/inc/backend/kirki-config-class/include-kirki.php';
}


/**
 *
 *	Custom types component
 * 
 */
require	plugin_dir_path( __FILE__ ) . '/inc/backend/posttypes/posttypes.php';


/**
 *
 *	Custom shortcodes component
 * 
 */
require	plugin_dir_path( __FILE__ ) . '/inc/frontend/shortcode-wrapper/shortcode-wrapper.php';


/*
*	Scripts and styles Backend
*	
*/
if(!function_exists("proradio_core_loader_backend")){
function proradio_core_loader_backend(){
	wp_enqueue_style( 'qtExtensionSuiteStyle',plugins_url( '/assets/style.admin.css' , __FILE__ ),false);
}}
add_action("admin_enqueue_scripts",'proradio_core_loader_backend');


/*
*
*	We add some columns with featured images in the post archive so is easier 
*
*/
if (function_exists( 'add_theme_support' )){
    add_filter('manage_posts_columns', 'proradio_core_posts_columns', 5);
    add_action('manage_posts_custom_column', 'proradio_core_posts_custom_columns', 5, 2);    
}
function proradio_core_posts_columns($defaults){
    $defaults['wps_post_thumbs'] = __('Thumbs',"proradio-core");
    $defaults['wps_post_id'] = __('Post ID',"proradio-core");
    return $defaults;
}
function proradio_core_posts_custom_columns($column_name, $id){
	if($column_name === 'wps_post_thumbs'){
        echo the_post_thumbnail( "thumbnail" );
    }
    if($column_name === 'wps_post_id'){
        echo get_the_ID();
    }
}



add_filter('style_loader_tag', 'proradio_core_remove_type_attr', 9999, 2);
add_filter('script_loader_tag', 'proradio_core_remove_type_attr', 9999, 2);


function proradio_core_remove_type_attr($tag, $handle) {
    return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
}


	

