<?php
/**
 * @package WordPress
 * @subpackage proradio-dedications
 * @version 1.0.0
 */

if(!function_exists('proradio_dedications_scroll')){
	function proradio_dedications_scroll($atts = []){
		/*
		 *  Defaults
		 *  All parameters can be bypassed by same attribute in the shortcode
		 */
		extract( shortcode_atts( array(
			'items_per_page'=> 3,
			'textlabel' => 'Dedications',
			'duration' => 60
		), $atts ) );

		$duration = intval($duration) * 10000;

		ob_start();
		remove_filter ('the_content', 'wpautop');
	   ?>
	   <div class="proradio-dedications-scroller " >
			<?php 
			if($textlabel){ 
				?>
				<div class="proradio-dedications-scroller__label">
					<span class="proradio-meta"><?php echo esc_html($textlabel); ?></span>
				</div>
				<?php 
			} 
			?>
			<div class="proradio-dedications-marquee" data-duplicated='true' data-direction='left' data-duration='<?php echo esc_attr($duration); ?>'>
				<?php 
				$args = array(
					'post_type'             => 'prdedicationslist',
					'post_status'           => 'publish',
					'ignore_sticky_posts'   => 1,
					'posts_per_page'        => $items_per_page,
					'paged'                 => 1,
					'orderby'               => array ('menu_order' => 'ASC', 'date' => 'DESC')
				);
				$wp_query = new WP_Query( $args );
				if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
					$post = $wp_query->post;
					setup_postdata( $post );
					$name =  get_post_meta( get_the_ID(), 'prdedication_name', true );
					$song =  get_post_meta( get_the_ID(), 'prdedication_song', true );
					$art =  get_post_meta( get_the_ID(), 'prdedication_art', true );
					$artlink = str_replace('100x100bb.jpg', '1000x1000bb.jpg', $art);
					if(!$name){
						$name = esc_html__('Dedication', 'proradio-dedication');
					}
					$content = get_the_content();
					if($content){
						?>
						<span class="proradio-dedication-inline-text">
							<span class="proradio-dedication-name">
								<?php echo esc_html( $name ); ?>
							</span>
							<?php  
							if($art){
								?><a href="<?php echo esc_url( $artlink ); ?>" class="proradio-dedication-thumb"><img src="<?php echo esc_url($art); ?>" width="60px" height="60px"></a><?php
							}
							if($song){
								if($art){ ?><a href="<?php echo esc_url($artlink ); ?>"><?php  }
								?><span class="proradio-dedication-song"><?php
								echo esc_html( $song );
								?></span> <?php  
								if($art){ ?></a><?php  }
							}
							if($art){

							}
							?>
							<span class="proradio-dedication-text">
								<?php echo wp_kses_post( wp_strip_all_tags( $content) ); ?>
							</span>
						</span>
						<?php  
					}
				endwhile; else:
					esc_html_e("Currently there are no new dedications","proradio-dedications"); 
				endif;
				wp_reset_postdata();
				?>
			</div>
		</div>
		<?php  
		add_filter ('the_content', 'wpautop');
		echo ob_get_clean();
	}   
}