<?php
/**
 * @package WordPress
 * @subpackage proradio-dedications
 * @version 1.1.2
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



// internal mail 

add_action('wp_ajax_nopriv_prdedications-sendform', 'prdedications_submit_form');
add_action('wp_ajax_prdedications-sendform', 'prdedications_submit_form');


function prdedications_get_edit_post_link( $id = 0, $context = 'display' ) {
	$post = get_post( $id );
	if ( ! $post ) {
		return;
	}

	if ( 'revision' === $post->post_type ) {
		$action = '';
	} elseif ( 'display' === $context ) {
		$action = '&amp;action=edit';
	} else {
		$action = '&action=edit';
	}

	$post_type_object = get_post_type_object( $post->post_type );
	if ( ! $post_type_object ) {
		return;
	}

	if ( $post_type_object->_edit_link ) {
		$link = admin_url( sprintf( $post_type_object->_edit_link . $action, $post->ID ) );
	} else {
		$link = '';
	}

	return apply_filters( 'get_edit_post_link', $link, $post->ID, $context );
}


/**
 * =============================================================
 * SUBMISSION
 * =============================================================
 * */
function prdedications_submit_form(){


	if( !isset($_POST['nonce']) ){
		// return 'Illegal action.';
		wp_die('error');
	}
	if ( ! wp_verify_nonce( $_POST['nonce'], 'prdedications-ajax-nonce' ) ){
		// return 'Illegal token.';
		wp_die('error');
	}

	if( !isset($_POST['isValid']) ){
		echo 'isValid: '.$_POST['isValid'];
		wp_die('error');
	}

	// Spambot fight honeypot
	if(array_key_exists('name', $_POST) || array_key_exists('email', $_POST)){
		
		if($_POST['name'] !== '' ){
			wp_die('success');
		}
		if($_POST['email'] !== '' ){
			wp_die('success');
		}
	}



	$client_ip = prdedications_getIPAddress();


	$blacklist_ips = get_option('prdedications-blacklist-ips');
	if($blacklist_ips){
		if (in_array($client_ip, array_map("trim", explode("\n", $blacklist_ips)))) {
			wp_die('error');
		}
	}

	if(get_option('prdedications-request-email') && array_key_exists('your-email', $_POST)){
		$blacklist_mail = get_option('prdedications-blacklist-mail');
		if($blacklist_mail){
			if (in_array(trim($_POST['your-email']), array_map("trim", explode("\n", $blacklist_mail)))) {
				wp_die('error');
			}
		}
	}


	/**
	 * =========================================================
	 * 
	 * Rate limiting
	 * 
	 * =========================================================
	 * */
	$limit = intval( get_option('prdedications-ratelimit', 20) );
	// echo "\n limit: ".$limit;
	// echo "\n client_ip: ".$client_ip;
	// get pending posts with this IP
	$args = array(
		'post_type'             => 'prdedicationslist',
		'post_status'           =>  array( 'pending', 'draft') ,
		'posts_per_page'        => -1,
		'paged'                 => 1,
		'meta_query' => array(
			array(
				'key' => 'prdedication_ip',
				'value' => trim( $client_ip )
			)
		)
	);
	$wp_query = new WP_Query( $args );
	$pending = $wp_query->found_posts;
	// echo "\n pending: ".$pending;
	if( $pending >= $limit ){
		// echo "\n block it: ";
		wp_die('limit');
	}


	


	if(get_option('prdedications-request-name') && !array_key_exists('your-name', $_POST)){
		wp_die('error');
	}

	if(get_option('prdedications-request-email') && !array_key_exists('your-email', $_POST)){
		wp_die('error');
	}

	if(get_option('prdedications-request-privacy') && !array_key_exists('privacy', $_POST)){
		wp_die('error');
	}

	
	
	

	if( isset( $_POST['pagelink'] )){
		$actual_link = trim ( $_POST['pagelink'] );
	} else {
		$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	}


	/**
	 * =========================================================
	 * 
	 * Store the data
	 * 
	 * =========================================================
	 * */

	$my_post = array(
		'post_type'   => 'prdedicationslist',
		'post_title'    => sanitize_text_field( esc_attr($client_ip) .' '.$_POST['your-name'] ),
		'post_content'  => sanitize_text_field( wp_kses_post( $_POST['your-message'] )),
		'post_status'   => 'draft',
		'meta_input'   => array(
			'prdedication_name' =>  (array_key_exists('your-name', $_POST) ) ?		sanitize_text_field($_POST['your-name']) : '',
			'prdedication_email' =>  (array_key_exists('your-email', $_POST) ) ?		sanitize_text_field($_POST['your-email']) : '',
			'prdedication_phone' =>  (array_key_exists('your-phone', $_POST) ) ?		sanitize_text_field($_POST['your-phone']) : '',
			'prdedication_privacy' => (array_key_exists('privacy', $_POST) ) ?		sanitize_text_field($_POST['privacy']) : '', 		
			'prdedication_link' => esc_url($actual_link),
			'prdedication_ip' => sanitize_text_field($client_ip), 		
			'prdedication_art' => (array_key_exists('song-artwork', $_POST) ) ?		sanitize_text_field($_POST['song-artwork']) : '',
			'prdedication_song' => 	(array_key_exists('your-song', $_POST) ) ?		sanitize_text_field(wp_kses_post($_POST['your-song'])) : '',
		),
	);
	$insert_post = wp_insert_post($my_post,true);
	if( !$insert_post ){
		wp_die ( 'error' );
	} 

	/**
	 * =========================================================
	 * 
	 * Send an email to the administrator
	 * 
	 * =========================================================
	 * */
	$message = '';

	if(get_option('prdedications-request-name') && array_key_exists('your-name', $_POST)){
		$message .= esc_html__('Name', 'proradio-dedications').': '. ' '.$_POST['your-name'];
		$message .= "\n <br><br>";
	}

	if(get_option('prdedications-request-email') && array_key_exists('your-email', $_POST)){
		$message .= esc_html__('Email', 'proradio-dedications').': '. ' '.sanitize_text_field($_POST['your-email']);
		$message .= "\n <br><br>";
	}

	if(get_option('prdedications-request-phone') && array_key_exists('your-phone', $_POST)){
		$message .= esc_html__('Phone', 'proradio-dedications').': '. ' '.sanitize_text_field($_POST['your-phone']);
		$message .= ' | <a href="tel:'.$_POST['your-phone'].'">'.esc_html__('Call back this number', 'proradio-dedications').'</a>';
		$message .= "\n <br><br>";
	}

	$message .= esc_html__('Message:', 'proradio-dedications').': '.sanitize_text_field($_POST['your-message']);
	$message .= "\n <br><br>";

	if(get_option('prdedications-request-song') && array_key_exists('your-song', $_POST)){
		$message .= esc_html__('Song:', 'proradio-dedications'). ': '.sanitize_text_field($_POST['your-song']);
		$message .= "\n <br><br>";
	}

	if(get_option('prdedications-request-privacy') && array_key_exists('privacy', $_POST)){
		$message .= esc_html__('Privacy', 'proradio-dedications'). ' '.sanitize_text_field($_POST['privacy'][0]);
		$message .= "\n <br><br>";
	}

	$message .= esc_html__('Client IP:', 'proradio-dedications'). ': '.sanitize_text_field($client_ip);
	$message .= "\n <br><br>";

	$message .= esc_html__('Page:', 'proradio-dedications').': ' . esc_url($actual_link). '<br> <a href="'. esc_url($actual_link).'" target="_blank">'.esc_html__('Open link', 'proradio-dedications').'</a>';
	$message .= "\n <br><br>";
	
	if( $insert_post ){
		$approve_link = prdedications_get_edit_post_link($insert_post);
		$message .= esc_html__('Dedication ID:', 'proradio-dedications'). $insert_post;
		$message .= "\n <br>";
		$message .= esc_html__('Approve or delete:', 'proradio-dedications'). ': <a href="'. esc_url($approve_link).'" target="_blank">'.esc_html__('Click here', 'proradio-dedications').'</a> ';
		$message .= "\n <br><br>";
		$message .= esc_html__('Link not working? Copy this in the browser:', 'proradio-dedications');
		$message .= "\n <br>";
		$message .= $approve_link;
		$message .= "\n <br>";
	}

	$headers = array('Content-Type: text/html; charset=UTF-8');
	$headers[] = 'Reply-To: '.esc_attr(trim(sanitize_text_field($_POST['your-email'])));

	$custom_email_admin = get_option('prdedications-admin-address');
	$to = ($custom_email_admin) ? $custom_email_admin : get_bloginfo('admin_email');

	if(get_option('prdedications-admin-notify')){
		$email_notification_ok = wp_mail( $to, esc_attr__( 'New dedication from the website', 'proradio-dedications'), $message, $headers);
		if( !$email_notification_ok ){
			$message =  esc_html__('[Error sending email notification]',  'proradio-dedications')."\n <br>". $message; 
		}
	} else {
		$message = __('Notifications are disabled', 'proradio-dedications');
	}

	update_post_meta( $insert_post, 'prdedication_notif', wp_kses_post( $message ) );

	/**
	 * =========================================================
	 * 
	 * Output response
	 * 
	 * =========================================================
	 * */
	wp_die ( 'success' );
	
}

