<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



class ProradioElementorPostScroller extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-post-scroller'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Post scroller', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-radio-feed';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}

	// Javascript
		
	public function __construct($data = [], $args = null) {
      parent::__construct($data, $args);
      wp_register_script( 'proradio-elementor-post-scroller', plugins_url( '/scroller.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
   	}
 	public function get_script_depends() {
	     return [ 'proradio-elementor-post-scroller' ];
	}


	protected function register_controls() {


		$this->start_controls_section(
			'proradio_elementor_section_query_global',
			[
				'label' => esc_html__( 'Query', 'proradio-elementor' ),
			]
		);	
			$this->add_control(
				'post_type',
				[
					'label' => esc_html__( 'Post type', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'options' =>[
						"post" => esc_html__( "Posts", 'proradio' ),
						"podcast" => esc_html__( "Podcast", 'proradio' ),
						'event' => esc_html__( "Events", 'proradio' ),
						'members' => esc_html__( "Team members", 'proradio' ),
						'chart' => esc_html__( "Charts", 'proradio' ),
					]
				]
			);
			$this->add_control(
				'tax_filter',
				[
					'label' => esc_html__( 'Category filters', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array('category, post_tag')
				]
			);
			$this->add_control(
				'tax_filter_exc',
				[
					'label' => esc_html__( 'Exclude by category', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array('category,post_tag')
				]
			);
			$this->add_control(
				'e_loadmore',
				[
					'label' => esc_html__( "Load more button", "proradio" ),
					'type' => Controls_Manager::SWITCHER,
				]
			);
		$this->end_controls_section();




		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Design', 'proradio-elementor' ),
			]
		);	

			
			$this->add_control(
				'pr_thumb',
				[
					'label' => esc_html__( 'Display thumbnail', 'proradio-elementor' ),
					'type' => Controls_Manager::SWITCHER,
					'default' => '1',
					'return_value' => '1',
				]
			);

			$this->add_responsive_control(
				'proradio-size',
				[
					'label' => esc_html__( 'Thumbnail', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 150,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'desktop_default' => [
						'size' => 1,
						'unit' => 'em',
					],
					'tablet_default' => [
						'size' => 1,
						'unit' => 'em',
					],
					'mobile_default' => [
						'size' => 1,
						'unit' => 'em',
					],
					'selectors' => [
						'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};max-width:100%;',			
					],
				]
			);
			$this->add_responsive_control(
				'proradio-thumbradius',
				[
					'label' => esc_html__( 'Border radius', 'elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%', 'rem' ],
					'selectors' => [
						'{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);


			$this->add_control(
				'duration',
				[
					'label' => esc_html__( 'Animation duration', 'textdomain' ),
					'description' => esc_html__( '1-20 where 20 = slowest', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 20,
					'step' => 1,
					'default' => 6,
				]
			);


			
			
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'proradio-txt-typo',
					'label' => esc_html__( 'Typography','proradio-elementor'),
					'scheme' => Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .proradio-post-scroller span'
				]
			);

			
			
			$this->add_control(
				'proradio-txt',
				[
					'label' => esc_html__( 'Text color', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-post-scroller a' => 'color: {{VALUE}} !important;',
					]
				]
			);
		$this->end_controls_section();
	}

	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		if(function_exists('proradio_post_scroller_function')){
			echo proradio_post_scroller_function( $atts );
		}
	}
	
	protected function content_template() {}
}