<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorSchedule extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-schedule'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Schedule', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-schedule';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}
	// Javascript
		/**
	 * @since version PR.2.3.0 loaded from minified scripts.
	 * To unse unminified, edit _plugin.php line 53 $use_minified_script = true;
	 * 
	 * 
	 * */
	 // public function __construct($data = [], $args = null) {
 //      parent::__construct($data, $args);
 //      wp_register_script( 'proradio-elementor-schedule', plugins_url( '/schedule.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
 //   	}
 // 	public function get_script_depends() {
	//      return [ 'proradio-elementor-schedule' ];
	// }
	// Controls
	protected function register_controls() {
		$this->start_controls_section(
			'proradio_elementor_query',
			[
				'label' => esc_html__( 'Settings', 'proradio-elementor' ),
			]
		);
			$this->add_control(
				'schedulefilter',
				[
					'label' => esc_html__( 'Schedule filters', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'options' => proradio_elementor_get_terms_array( 'schedulefilter' )
				]
			);

			$this->add_control(
				'schedule_style',
				[
					'label' => esc_html__( 'Style', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'options' =>[
						"" 	=> 	esc_html__( "Default","elementor-proradio"),
						"proradio-schedule--row" 	=> 	esc_html__( "Rows","elementor-proradio"),
					]
				]
			);

			$this->add_responsive_control(
				'schedule_thumb_w',
				[
					'label' => esc_html__( 'Thumbnail width in row mode', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 60,
							'max' => 300,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} ' => '--proradio-schedule--row-thumb-width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'schedule_thumb_h',
				[
					'label' => esc_html__( 'Thumbnail height in row mode', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 60,
							'max' => 200,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} ' => '--proradio-schedule--row-thumb-height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'schedule_fontsize',
				[
					'label' => esc_html__( 'Caption size', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 13,
							'max' => 30,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} h3' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'schedule_switch',
				[
					'label' => esc_html__( 'Design switch', 'proradio-elementor' ),
					'type' => Controls_Manager::SWITCHER,
					'return_value' => 'proradio-schedule--switch',
				]
			);

			$this->add_control(
				'thumbsize',
				[
					'label' => esc_html__( 'Image size', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'default' => 'medium',
					'options' =>[
						'proradio-squared-s' => esc_html__( "Squared small", "proradioelementor"),
						'proradio-squared-m' => esc_html__( "Squared medium", "proradioelementor"),
						'thumbnail' => esc_html__( "Thumbnail", "proradioelementor"),
						'medium' => esc_html__( "Medium", "proradioelementor"),
						'large' => esc_html__( "Large", "proradioelementor"),
					]
				]
			);

			$this->add_control(
				'tabs-bg',
				[
					'label' => esc_html__( 'Tabs background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-tabs__menu' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'tabs-color',
				[
					'label' => esc_html__( 'Tabs color', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-tabs__menu' => 'color: {{VALUE}};',
					],
				]
			);
			
		$this->end_controls_section();
	}
	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		if(array_key_exists('schedulefilter', $atts)){
			if(is_array($atts['schedulefilter'])) {
				$atts['schedulefilter'] = implode(',', $atts['schedulefilter']);
			}
		}
		if(function_exists('proradio_showgrid')){
			echo proradio_showgrid( $atts );
		}
	}
	protected function content_template() {}
}