<?php
/**
 * @package proradio-megafooter
 */

if(!function_exists('proradio_megafooter_display_header')){
	// add_action('wp_footer', 'proradio_megafooter_display_header');
	function proradio_megafooter_display_header( $custom_footer = false ){

		
		if( !function_exists('proradio_megafooter_posttype_name')){
			return;
		}

		if ( get_post_type( get_the_ID() ) === proradio_megafooter_posttype_name() ) {
			return;
		}



		// Check if the actual post has a special footer selected
		wp_reset_postdata();
		wp_reset_query();



		if( $custom_footer ){
			$args = array(
			  'p'         => intval($custom_footer), // ID of a page, post, or custom type
			  'post_type' => proradio_megafooter_posttype_name()
			);
			$idarr = $custom_footer;
		} else {

			$granular_header = false;

			if(is_singular() || is_page()){
				global $post;
				if(isset($post)){
					$granular_header = get_post_meta( $post->ID,  'proradio-megafooter-header-granular', true );
					if( $granular_header == 'hide' ){
						return; // stop all, no footers here
					}
				}
			} 

			if($granular_header && $granular_header != 'hide'){
				// Display a specific footer
				$args = array(
				  'p'         => intval($granular_header), // ID of a page, post, or custom type
				  'post_type' => proradio_megafooter_posttype_name()
				);
				$idarr = $granular_header;
			} else {
				// get the list of footers from the customizer
				$proradio_megaheaders = get_theme_mod( 'proradio_megaheaders' );
				if($proradio_megaheaders){
					$idarr = [];
					foreach( $proradio_megaheaders as $footer => $val ){
						if( $val && !empty($val) && '' !=  $val['mega_header']){
							$idarr[] = $val['mega_header'];
						}
					}
					if(count($idarr) > 0){
						$quantity = count($idarr);
						$args = array(
							'post__in'=> $idarr,
							'post_type' =>  proradio_megafooter_posttype_name(),
							'orderby' => 'post__in',
							'posts_per_page' => intval($quantity),
							'ignore_sticky_posts' => 1
						);  
					}
				}
			}
		}

		if(!isset($args) ||  !$args){
			return;
		} 

		global $wp_query;
		$wp_query = new WP_Query( $args );
		if ( $wp_query->have_posts() ) { 
			?>
			<div id="proradio-megafooter-header" class="proradio-megafooter__container proradio-megafooter__container--header">
				<?php 
				while ( $wp_query->have_posts() ) : $wp_query->the_post();
					$post = $wp_query->post;
					setup_postdata( $post );
					?>
					<div id='proradio-megafooter-item-<?php echo $post->ID; ?>' <?php post_class( 'proradio-megafooter__item' ); ?> >
						<div class="proradio-megafooter__itemcontent">
							<?php
							echo apply_filters('the_content', get_the_content( $post->ID ) );
							?>
						</div>
					</div>
					<?php
					wp_reset_postdata();
				endwhile;
				?>
			</div>
			<?php
		}
		wp_reset_query();
		return;
	}
}

