<?php 
/**
 * @package Pro.Radio Business Tools
 * 
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if(!function_exists('qtmplayer_stats_frontend')){
	add_shortcode('qtmplayer-stats','qtmplayer_stats_frontend');
	function qtmplayer_stats_frontend($atts = []){

		if( ! qtmplayer_user_can_view_stats() || ! get_option('qtmplayer_stats_enabled')){
			return;
		}
		ob_start();



		// Open stats box
		?><div class="qtmplayer-chart-container qtmplayer-stats-box"><?php 



		/**
		 * =========================================================
		 * Variables extraction
		 * =========================================================
		 * */
		extract( shortcode_atts( array(
				'post_id' => false,
			), $atts ) );


		

		/**
		 * =========================================================
		 * Administrator can generate fake test stats
		 * =========================================================
		 * */
		if(is_user_logged_in()){
			$user = wp_get_current_user();
			$allowed_roles = array( 'administrator' );
			if( array_intersect($allowed_roles, $user->roles ) ) {
				?>
				<div class="qtmplayer-stats-box">
				<h3>Generate demo stats</h3>
				<a href="<?php echo add_query_arg('qtmplayer-stats-create-demodata', get_the_ID() ,get_the_permalink()); ?>" onclick="return confirm('are you sure? This will erase any stored statistics for this page')" target="_blank"><?php esc_html_e('Create demo data', 'qtmplayer'); ?></a>

				</div>
				<?php
			}
		}

		

		$post_meta_name = qtmplayer_stats_meta_name();
		$post_id = ( $post_id ) ? $post_id : get_the_ID() ;
		$post_meta = get_post_meta( $post_id, $post_meta_name, true);
		$stats = false;
		if($post_meta){
			$stats = array_unique( maybe_unserialize( $post_meta ), SORT_REGULAR );
		}
		if(!$stats){
			?>
			
				<h2><?php esc_html_e('Stats', 'qtmplayer'); ?></h2>
				<?php esc_html_e('No stored stats events', 'qtmplayer'); ?>
			</div>
			<?php
			return ob_get_clean();
		}


		

		/**
		 * =========================================================
		 * Chart
		 * =========================================================
		 * */
		/**
		 * =========================================================
		 * Used for the chart, do not modify
		 * =========================================================
		 * */
		// $stats = unserialize( get_post_meta($post_id,'qtmplayer-stats', true) );
		$stats = array_unique( maybe_unserialize( $post_meta ), SORT_REGULAR );
		if( $stats ){

			$n = 60;
			$data = array_slice($stats, -$n, $n, true);
			$stats_json = json_encode( $data );
			echo '<pre id="qtmplayer-stats-source" class="qtmplayer-stats-source">';
			print_r ( $stats_json );
			echo '</pre>';
			?>
			
			
			<h2><?php esc_html_e('Stats', 'qtmplayer'); ?></h2>
		
			<canvas id="qtmplayer-chart" class="qtmplayer-chart" width="400" height="400"></canvas>
			
			<?php  
		}

		


		/**
		 * =========================================================
		 * Table
		 * =========================================================
		 * */

		/*
		?>
		
		<h4><?php esc_html_e( 'Click details' , 'qtmplayer' ); ?></h4>
		<div class="qtmplayer-longtable">
			<div class="qtmplayer-table-container">
				<table >
					<tbody>
						<tr><th><?php esc_html_e( 'Day', 'qtmplayer' ); ?></th><th><?php esc_html_e( 'Unique play', 'qtmplayer' ); ?></th><th><?php esc_html_e( 'Total play', 'qtmplayer' ); ?></th></tr>
						<?php 
						if( $stats ){
							foreach( $stats as $day => $clicks ){
								?>
								<tr><td><?php echo esc_html(  $day ); ?></td><td><?php echo esc_html( $clicks['U'] ); ?></td><td><?php echo esc_html( $clicks['T'] ); ?></td></tr>
								<?php 
							}
						} else {
							?>
							<tr><td><?php esc_html_e( 'No data available', 'qtmplayer' ); ?></td><td><?php esc_html_e( 'No data available', 'qtmplayer' ); ?></td></tr>
							<?php
						}
						?>
					</tbody>
				</table>
			</div>
		</div>
		<?php
		*/



		/**
		 * =========================================================
		 * Table
		 * =========================================================
		 * */

		
		?>
		
		<h4><?php esc_html_e( 'Monthly play' , 'qtmplayer' ); ?></h4>
		<div class="qtmplayer-longtable">
			<div class="qtmplayer-table-container">
				<table >
					<tbody>
						<tr><th><?php esc_html_e( 'Month', 'qtmplayer' ); ?></th><th><?php esc_html_e( 'Unique play', 'qtmplayer' ); ?></th><th><?php esc_html_e( 'Total play', 'qtmplayer' ); ?></th></tr>
						<?php 



						// Days to months
						$months = [];

						if( $stats ){
							foreach( $stats as $day => $clicks ){
								$time_input = strtotime($day); 
								$date_input = getDate($time_input); 
								$month = $date_input['month'];
								if(array_key_exists($month, $months) ){
									$months[$month]['U'] = $months[$month]['U'] + $clicks['U'];
									$months[$month]['T'] = $months[$month]['T'] + $clicks['T'];
								} else {
									$months[$month]['U'] = $clicks['U'];
									$months[$month]['T'] = $clicks['T'];
								}
							}
						}


						if( $stats ){
							foreach( $months as $month => $clicks ){
								?>
								<tr><td><?php echo esc_html(  $month ); ?></td><td><?php echo esc_html( $clicks['U'] ); ?></td><td><?php echo esc_html( $clicks['T'] ); ?></td></tr>
								<?php 
							}
						} else {
							?>
							<tr><td><?php esc_html_e( 'No data available', 'qtmplayer' ); ?></td><td><?php esc_html_e( 'No data available', 'qtmplayer' ); ?></td></tr>
							<?php
						}
						?>
					</tbody>
				</table>
			</div>
		</div>
	<?php  

	// Close stats box
	?></div><?php
		

	
		
		return ob_get_clean();
	}
}