<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.1
 * Off canvas
 */
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

?>
<nav id="proradio-overlay" class="proradio-overlay proradio-paper <?php echo esc_attr(get_theme_mod('offcanvas_anim')); ?>">
	<div class="proradio-overlay__closebar"><span class="proradio-btn proradio-btn__r"  data-proradio-switch="proradio-overlayopen" data-proradio-target="#proradio-body"> <i class="material-icons">close</i></span></div>


	<?php  
	/**
	 * =======================================================
	 * MOBILE ONLY
	 * =======================================================
	 */
	?>
	<div class="proradio-hide-on-large-only">
		<?php
		/**
		 * ============================================
		 * CTA / Popup button
		 * ============================================
		 */
		get_template_part( 'template-parts/header/cta-mobile' );




		/**
		 * ============================================
		 * Remove any trace of megamenu classes to be very sure
		 * ============================================
		 */
		function proradio_nav_menu_css_class($classes) {
		    $custom_classes = array();
		    foreach($classes as $class) {
		        $class = str_replace('proradio-megamenu-is', 'proradio-megamenu-was', $class);
		        $custom_classes[] = $class;
		    }
		    return $custom_classes;
		}
		add_filter('nav_menu_css_class', 'proradio_nav_menu_css_class');





		?>
		<?php  
		if( get_theme_mod('radiochannel_oc_mob' ) ){
			?>
			<ul class="proradio-menu-tree">
				<?php
					get_template_part( 'template-parts/misc/radiochannels-dropdown' ); 	
				?>
			</ul>
			<?php 
		}
		 
	


		/**
		 * ============================================
		 * Mobile ONLY menu
		 * ============================================
		 */
		if ( has_nav_menu( 'proradio_menu_mobile' ) ) { 
			$menu_classes = ['proradio-menu-tree', 'proradio-menu-tree__mobile' ];
			?>
			<ul id="proradio-menu-tree-mobile" class="<?php echo esc_attr( implode(' ', $menu_classes ) ); ?>">
				<?php
				wp_nav_menu( array (
					'theme_location' => 'proradio_menu_mobile',
					'depth' => 3,
					'container' => false,
					'items_wrap' => '%3$s'
				) );
				?>
			</ul>
			<?php 
		}



		/**
		 * ============================================
		 * Primary menu - mobile sidebar
		 * ============================================
		 */
		if ( has_nav_menu( 'proradio_menu_primary' ) ) { 
			$menu_classes = ['proradio-menu-tree'];
			
			if ( has_nav_menu( 'proradio_menu_mobile' ) ){
				$menu_classes[] = 'proradio-hide-on-large-and-down';
			}
			?>
			<ul id="proradio-menu-tree-default" class=" <?php echo esc_attr( implode(' ', $menu_classes ) ); ?>">
				<?php
				wp_nav_menu( array (
					'theme_location' => 'proradio_menu_primary',
					'depth' => 3,
					'container' => false,
					'items_wrap' => '%3$s'
				) );
				?>
			</ul>
			<?php 
		}

		/**
		 * ============================================
		 * Secondary menu - mobile sidebar
		 * ============================================
		 */
		if ( has_nav_menu( 'proradio_menu_secondary' ) ) { 
			?>
			<ul class="proradio-menu-tree proradio-menu-tree__secondary">
				<?php  
					wp_nav_menu( array(
						'theme_location' => 'proradio_menu_secondary',
						'depth' => 1,
						'container' => false,
						'items_wrap' => '%3$s'
					) );
				?>
			</ul>
			<?php 
		} 
		?>
	</div>
	<?php  

	/**
	 * =======================================================
	 * MOBILE ONLY END
	 * =======================================================
	 */





	/**
	 * =======================================================
	 * DESKTOP ONLY
	 * =======================================================
	 */
	?>
	<div class="proradio-hide-on-large-and-down">
		<?php 
		/**
		 * Primary menu - mobile sidebar
		 */
		if ( has_nav_menu( 'proradio_menu_desktop_off' ) || get_theme_mod('radiochannel_oc_desktop' ) ) { 
			?>
			<ul class="proradio-menu-tree">

				<?php 
				
				if(get_theme_mod('radiochannel_oc_desktop' ) ){
					get_template_part( 'template-parts/misc/radiochannels-dropdown' ); 	
				}
				
				?>


				<?php
				if ( has_nav_menu( 'proradio_menu_desktop_off' )){
					wp_nav_menu( array (
						'theme_location' => 'proradio_menu_desktop_off',
						'depth' => 3,
						'container' => false,
						'items_wrap' => '%3$s'
					) );
				}
				?>
			</ul>
			<?php 
		} 
		?>
	</div>
	<?php  
	/**
	 * =======================================================
	 * DESKTOP ONLY END
	 * =======================================================
	 */

	/**
	 * =======================================================
	 * OFF CANVAS SIDEBAR
	 * =======================================================
	 */
	if( is_active_sidebar( 'proradio-offcanvas-sidebar' ) ){
		?>
		<div id="proradio-sidebar-offcanvas" role="complementary" class="proradio-sidebar proradio-sidebar__secondary proradio-sidebar__offcanvas">
			<ul class="proradio-row">
				<?php dynamic_sidebar( 'proradio-offcanvas-sidebar' ); ?>
			</ul>
		</div>
		<?php 
	}
	/**
	 * =======================================================
	 * OFF CANVAS SIDEBAR END
	 * =======================================================
	 */
	?>


	<?php  
	/**
	 * ======================================================
	 * Social icons
	 * ======================================================
	 */ 
	
	
	if (function_exists( 'proradio_qt_socicons_array' ) && get_theme_mod( 'show_social_secondaryheader',1 )){
		$social_offcanvas = proradio_qt_socicons_array();
		$icons_amount = 0;
		krsort($social_offcanvas);
		if(is_array($social_offcanvas)){
			if( count($social_offcanvas )>0 ){
				ob_start();
				foreach($social_offcanvas as $var => $val){
					$link = get_theme_mod( 'proradio_social_'.$var );
					if($link){
						$icons_amount = $icons_amount + 1;
						?>
						<a href="<?php echo esc_url($link); ?>" class="qt-disableembedding proradio-soc-icon" target="_blank"><i class="qt-socicon-<?php echo esc_attr($var); ?> qt-socialicon"></i></a>
						<?php
					}
				}
				$social_icons = ob_get_clean();
				if( $icons_amount > 0 ){
					?>
					<div class="proradio-overlay__social">
						<?php echo $social_icons; ?>
					</div>
					<?php
				}

			}
		}
	}
	?>
</nav>
<div class="proradio-overlay__pagemask" data-proradio-switch="proradio-overlayopen" data-proradio-target="#proradio-body"></div>













