<?php  
/**
 * 
 * =============================================================
 * Server GET
 * =============================================================
 * 
 */				
?>
<h1>Default server</h1>
<h2>Attempting to get ID</h2>
<?php 
 if(function_exists('proradio_iid')){
 	echo 'ID: '. proradio_iid(true);
 } else {
 	echo 'Theme not installed';
 }
?>

<h3>Server GET test</h3>
<div class="proradio-servercheck__test">
	<?php  
	// HTML
	$url = 'https://pro.radio/proradio-connector/connector-proxy/proradio-servercheck-get.html';
	
	$args = array(
		'method'        => 'GET',
		'timeout'       => 45,
		'redirection'   => 5,
		'httpversion'   => '1.0',
		'blocking'      => true,
		 'sslverify' => false,
		'body'          => array( 
			'sssite_host' => get_site_url(),
			'ssdate' => base64_encode(date("m-d-Y H:i:s.u")),
			'sstheme_version'  => esc_attr( $current_theme->version )
		),
	);

	$response = wp_remote_get( $url , $args);
	if ( is_wp_error( $response ) ) {
		$error_message = $response->get_error_message();
		echo '<p class="proradio-servercheck__fail">FAIL</p>';
	   	echo "<p>Something went wrong: ". wp_kses_post($error_message).'</p>';
	   	echo "<p>You won't be able to use automatic updates and installations. Please check the support section of the manual for an alternative solution</p>";		  
	} else {
		echo '<p class="proradio-servercheck__success">PASSED</p>';
		echo "<p>It seems your server can correctly download the plugins from our repository.</p>";	
		echo $response['body'];
	}
	?>
</div>
